/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum DataEngineAuditCode {
    SERVICE_INITIALIZING("OMAS-DATA-ENGINE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Data Engine Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Data Engine OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-DATA-ENGINE-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Data Engine Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Data Engine OMAS has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-DATA-ENGINE-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Data Engine Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local server has requested shut down of an Data Engine OMAS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-DATA-ENGINE-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Engine Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ERROR_INITIALIZING_TOPIC_CONNECTION("OMAS-DATA-ENGINE-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Engine Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    PROCESS_EVENT_EXCEPTION("OMAS- DATA-ENGINE-0006", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Engine Open Metadata Access Service (OMAS) is unable to process an event on its in topic {0}; exception {1} returned error message: {2}", "The access service detected an error during the start up of the out topic.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Check the status of the event bus.  Once this is resolved, restart the server."),
    PARSE_EVENT_EXCEPTION("OMAS- DATA-ENGINE-0007", OMRSAuditLogRecordSeverity.EXCEPTION, "The data engine event {0} could not be parsed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    IN_TOPIC_EVENT_SENT("OMAS-DATA-ENGINE-0008", OMRSAuditLogRecordSeverity.EVENT, "The Data Engine Open Metadata Access Service (OMAS) client has sent event: {0}", "The access service client sends out event notification produced by external source like data engine system.", "This event contains external metadata changes that need to be processed by the access service.");

    private final AuditLogMessageDefinition messageDefinition;

    private DataEngineAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "DataEngineAuditCode." + this.name() + "(messageDefinition=" + this.getMessageDefinition(new String[0]) + ")";
    }

    private static class Constants {
        public static final String NO_ACTION_IS_REQUIRED = "No action is required.  This is part of the normal operation of the service.";

        private Constants() {
        }
    }
}

