/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataEngineErrorCode implements ExceptionMessageSet
{
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-ENGINE-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    REFERENCEABLE_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-001", "Referenceable with qualifiedName {0} was not found", "The system is unable to create a new DataFlow relation.", "Correct the code in the caller to provide the correct referenceable qualified name."),
    NULL_TOPIC_CONNECTOR(400, "OMAS-DATA-ENGINE-400-002", "Unable to send or receive events for source {0} because the connector to the OMRS Topic failed to initialize", "The local server will not connect to the cohort.", "The connection to the connector is configured in the server configuration.  Review previous error messages to determine the precise error in the start up configuration. Correct the configuration and reconnect the server to the cohort. "),
    PROCESS_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-003", "Process with qualifiedName {0} was not found", "The system is unable to create a new ProcessHierarchy relation.", "Correct the code in the caller to provide the correct port qualified name."),
    DATABASE_SCHEMA_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-004", "Database Schema with qualifiedName {0} was not found", "The system is unable to create a new table attached to a database schema", "Correct the code in the caller to provide the correct database schema qualified name."),
    UNABLE_TO_SEND_EVENT(500, "OMAS-DATA-ENGINE-500-001", "An unexpected exception occurred when sending an event through connector {0} to the Data Engine OMAS out topic.  The failing event was {1}, the exception was {2} with message {2}", "The system has issued a call to an open metadata access service input topic using event message broker", "Look for errors in the remote server's audit log and console to understand and correct the source of the error."),
    ENTITY_NOT_DELETED(400, "OMAS-DATA-ENGINE-400-005", "Entity with qualifiedName {0} was not deleted", "The system is unable to delete the entity with the provided qualifiedName or guid.", "Correct the code in the caller to provide the correct database qualified name."),
    METHOD_NOT_IMPLEMENTED(501, "OMAS-DATA-ENGINE-500-002", "Method {0} is not implemented", "The system performs no action as the method is not implemented.", "No action suggested."),
    TOPIC_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-006", "Topic with qualifiedName {0} was not found", "The system is unable to create a new event type attached to a topic", "Correct the code in the caller to provide the correct topic qualified name."),
    ENGINE_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-007", "Engine with qualifiedName {0} was not found", "The system is unable to find the searched Engine", "Correct the code in the caller to provide the correct Engine qualified name.");

    private static final long serialVersionUID = 1L;
    private final ExceptionMessageDefinition messageDefinition;

    private DataEngineErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

