/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.PortType;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineOMASAPIRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.springframework.util.CollectionUtils;

public class DataEngineImpl
extends OCFRESTClient
implements DataEngineClient {
    private static final String QUALIFIED_NAME_PARAMETER = "qualifiedName";
    private static final String PROCESS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/processes";
    private static final String DATA_ENGINE_REGISTRATION_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/registration";
    private static final String SCHEMA_TYPE_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/schema-types";
    private static final String PORT_IMPLEMENTATION_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/port-implementations";
    private static final String PORT_ALIAS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/port-aliases";
    private static final String LINEAGE_MAPPINGS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/lineage-mappings";
    private static final String PORTS_TO_PROCESS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/processes/{2}/ports";
    private String serverName;
    private String serverPlatformRootURL;
    private String externalSourceName;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public DataEngineImpl(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
    }

    public DataEngineImpl(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    @Override
    public String createOrUpdateProcess(String userId, String qualifiedName, String processName, String description, String latestChange, List<String> zoneMembership, String displayName, String formula, String owner, OwnerType ownerType, List<PortImplementation> portImplementations, List<PortAlias> portAliases, List<LineageMapping> lineageMappings, UpdateSemantic updateSemantic) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createOrUpdateProcesses";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateProcesses");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdateProcesses");
        ProcessesRequestBody requestBody = new ProcessesRequestBody();
        requestBody.setProcesses(Collections.singletonList(new Process(qualifiedName, processName, description, latestChange, zoneMembership, displayName, formula, owner, ownerType, portImplementations, portAliases, lineageMappings, updateSemantic)));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callProcessListPostRESTCall(userId, "createOrUpdateProcesses", PROCESS_URL_TEMPLATE, requestBody, new Object[0]).get(0);
    }

    @Override
    public String createOrUpdateProcess(String userId, String qualifiedName, String processName, String description, String latestChange, List<String> zoneMembership, String displayName, String formula, String owner, OwnerType ownerType, List<PortImplementation> portImplementations, List<PortAlias> portAliases, List<LineageMapping> lineageMappings) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createOrUpdateProcesses";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateProcesses");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdateProcesses");
        ProcessesRequestBody requestBody = new ProcessesRequestBody();
        requestBody.setProcesses(Collections.singletonList(new Process(qualifiedName, processName, description, latestChange, zoneMembership, displayName, formula, owner, ownerType, portImplementations, portAliases, lineageMappings, UpdateSemantic.REPLACE)));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callProcessListPostRESTCall(userId, "createOrUpdateProcesses", PROCESS_URL_TEMPLATE, requestBody, new Object[0]).get(0);
    }

    @Override
    public String createOrUpdateProcess(String userId, Process process) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateProcesses";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateProcesses");
        ProcessesRequestBody requestBody = new ProcessesRequestBody();
        requestBody.setProcesses(Collections.singletonList(process));
        requestBody.setExternalSourceName(this.externalSourceName);
        List<String> result = this.callProcessListPostRESTCall(userId, "createOrUpdateProcesses", PROCESS_URL_TEMPLATE, requestBody, new Object[0]);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<String> createOrUpdateProcesses(String userId, List<Process> processes) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateProcesses";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateProcesses");
        ProcessesRequestBody requestBody = new ProcessesRequestBody();
        requestBody.setProcesses(processes);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callProcessListPostRESTCall(userId, "createOrUpdateProcesses", PROCESS_URL_TEMPLATE, requestBody, new Object[0]);
    }

    @Override
    public String createExternalDataEngine(String userId, String qualifiedName, String name, String description, String type, String version, String patchLevel, String source) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalDataEngine";
        this.invalidParameterHandler.validateUserId(userId, "createExternalDataEngine");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createExternalDataEngine");
        DataEngineRegistrationRequestBody requestBody = new DataEngineRegistrationRequestBody();
        requestBody.setSoftwareServerCapability(new SoftwareServerCapability(qualifiedName, name, description, type, version, patchLevel, source));
        this.setExternalSourceName(qualifiedName);
        return this.callGUIDPostRESTCall(userId, "createExternalDataEngine", DATA_ENGINE_REGISTRATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalDataEngine";
        this.invalidParameterHandler.validateUserId(userId, "createExternalDataEngine");
        DataEngineRegistrationRequestBody requestBody = new DataEngineRegistrationRequestBody();
        requestBody.setSoftwareServerCapability(softwareServerCapability);
        this.setExternalSourceName(softwareServerCapability.getQualifiedName());
        return this.callGUIDPostRESTCall(userId, "createExternalDataEngine", DATA_ENGINE_REGISTRATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, String qualifiedName, String displayName, String author, String encodingStandard, String usage, String versionNumber, List<Attribute> attributeList) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateSchemaType");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdateSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setSchemaType(new SchemaType(qualifiedName, displayName, author, usage, encodingStandard, versionNumber, attributeList));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdateSchemaType", SCHEMA_TYPE_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateSchemaType");
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdateSchemaType", SCHEMA_TYPE_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, String qualifiedName, String displayName, PortType portType, SchemaType schemaType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdatePortImplementation";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdatePortImplementation");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdatePortImplementation");
        PortImplementationRequestBody requestBody = new PortImplementationRequestBody();
        requestBody.setPortImplementation(new PortImplementation(qualifiedName, displayName, portType, schemaType, UpdateSemantic.REPLACE));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdatePortImplementation", PORT_IMPLEMENTATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, String qualifiedName, String displayName, PortType portType, SchemaType schemaType, UpdateSemantic updateSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdatePortImplementation";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdatePortImplementation");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdatePortImplementation");
        PortImplementationRequestBody requestBody = new PortImplementationRequestBody();
        requestBody.setPortImplementation(new PortImplementation(qualifiedName, displayName, portType, schemaType, updateSemantic));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdatePortImplementation", PORT_IMPLEMENTATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, PortImplementation portImplementation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdatePortImplementation";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdatePortImplementation");
        PortImplementationRequestBody requestBody = new PortImplementationRequestBody();
        requestBody.setPortImplementation(portImplementation);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdatePortImplementation", PORT_IMPLEMENTATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, String qualifiedName, String displayName, PortType portType, String delegatesTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdatePortAlias";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdatePortAlias");
        this.invalidParameterHandler.validateName(qualifiedName, QUALIFIED_NAME_PARAMETER, "createOrUpdatePortAlias");
        PortAliasRequestBody requestBody = new PortAliasRequestBody();
        requestBody.setPortAlias(new PortAlias(qualifiedName, displayName, portType, delegatesTo));
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdatePortAlias", PORT_ALIAS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, PortAlias portAlias) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdatePortAlias";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdatePortAlias");
        PortAliasRequestBody requestBody = new PortAliasRequestBody();
        requestBody.setPortAlias(portAlias);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, "createOrUpdatePortAlias", PORT_ALIAS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public void addLineageMappings(String userId, List<LineageMapping> lineageMappings) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addLineageMappings";
        this.invalidParameterHandler.validateUserId(userId, "addLineageMappings");
        LineageMappingsRequestBody requestBody = new LineageMappingsRequestBody();
        requestBody.setLineageMappings(lineageMappings);
        requestBody.setExternalSourceName(this.externalSourceName);
        this.callVoidPostRESTCall(userId, "addLineageMappings", LINEAGE_MAPPINGS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public void addPortsToProcess(String userId, List<String> portGUIDs, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortsToProcess";
        this.invalidParameterHandler.validateUserId(userId, "addPortsToProcess");
        PortListRequestBody requestBody = new PortListRequestBody();
        requestBody.setPorts(portGUIDs);
        requestBody.setExternalSourceName(this.externalSourceName);
        this.callVoidPostRESTCall(userId, "addPortsToProcess", PORTS_TO_PROCESS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, processGUID);
    }

    private void callVoidPostRESTCall(String userId, String methodName, String urlTemplate, DataEngineOMASAPIRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        VoidResponse restResult = super.callVoidPostRESTCall(methodName, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
    }

    private String callGUIDPostRESTCall(String userId, String methodName, String urlTemplate, DataEngineOMASAPIRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GUIDResponse restResult = super.callGUIDPostRESTCall(methodName, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    private List<String> callProcessListPostRESTCall(String userId, String methodName, String urlTemplate, ProcessesRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        ProcessListResponse restResult = (ProcessListResponse)super.callPostRESTCall(methodName, ProcessListResponse.class, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }
}

