/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.connectors.intopic.DataEngineInTopicClientConnector;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventType;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessHierarchyEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessesDeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessesEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.SchemaTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class DataEngineEventClient
implements DataEngineClient {
    private DataEngineInTopicClientConnector topicConnector;
    private String externalSource;
    private DeleteSemantic deleteSemantic = DeleteSemantic.HARD;

    public DataEngineEventClient(DataEngineInTopicClientConnector dataEngineInTopicClientConnector) {
        this.topicConnector = dataEngineInTopicClientConnector;
    }

    public DeleteSemantic getDeleteSemantic() {
        return this.deleteSemantic;
    }

    public void setDeleteSemantic(DeleteSemantic deleteSemantic) {
        this.deleteSemantic = deleteSemantic;
    }

    @Override
    public List<String> createOrUpdateProcesses(String userId, List<Process> processes) throws InvalidParameterException, ConnectorCheckedException {
        ProcessesEvent event = new ProcessesEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PROCESSES_EVENT);
        event.setProcesses(processes);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteProcesses(String userId, List<String> qualifiedNames, List<String> guids) throws InvalidParameterException, ConnectorCheckedException {
        ProcessesDeleteEvent event = new ProcessesDeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DELETE_PROCESSES_EVENT);
        event.setQualifiedNames(qualifiedNames);
        event.setGuids(guids);
        event.setDeleteSemantic(this.deleteSemantic);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, ConnectorCheckedException {
        DataEngineRegistrationEvent event = new DataEngineRegistrationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DATA_ENGINE_REGISTRATION_EVENT);
        event.setSoftwareServerCapability(softwareServerCapability);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteExternalDataEngine(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_DATA_ENGINE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, ConnectorCheckedException {
        SchemaTypeEvent event = new SchemaTypeEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.SCHEMA_TYPE_EVENT);
        event.setSchemaType(schemaType);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteSchemaType(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_SCHEMA_TYPE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, PortImplementation portImplementation, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortImplementationEvent event = new PortImplementationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PORT_IMPLEMENTATION_EVENT);
        event.setPortImplementation(portImplementation);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortImplementation(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_PORT_IMPLEMENTATION_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, PortAlias portAlias, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortAliasEvent event = new PortAliasEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PORT_ALIAS_EVENT);
        event.setPort(portAlias);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortAlias(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_PORT_ALIAS_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String addProcessHierarchy(String userId, ProcessHierarchy processHierarchy) throws InvalidParameterException, ConnectorCheckedException {
        ProcessHierarchyEvent event = new ProcessHierarchyEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PROCESS_HIERARCHY_EVENT);
        event.setProcessHierarchy(processHierarchy);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void addLineageMappings(String userId, List<LineageMapping> lineageMappings) throws InvalidParameterException, ConnectorCheckedException {
        LineageMappingsEvent event = new LineageMappingsEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.LINEAGE_MAPPINGS_EVENT);
        event.setLineageMappings(lineageMappings);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void setExternalSourceName(String externalSourceName) {
        this.externalSource = externalSourceName;
    }

    @Override
    public String getExternalSourceName() {
        return this.externalSource;
    }

    private DeleteEvent getDeleteEvent(String userId, String qualifiedName, String guid) {
        DeleteEvent event = new DeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setQualifiedName(qualifiedName);
        event.setGuid(guid);
        event.setDeleteSemantic(this.deleteSemantic);
        return event;
    }
}

