/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineOMASAPIRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataEngineRESTClient
extends OCFRESTClient
implements DataEngineClient {
    private static final String DATA_ENGINE_PATH = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/";
    private static final String PROCESS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/processes";
    private static final String DATA_ENGINE_REGISTRATION_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/registration";
    private static final String SCHEMA_TYPE_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/schema-types";
    private static final String PORT_IMPLEMENTATION_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/port-implementations";
    private static final String PORT_ALIAS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/port-aliases";
    private static final String LINEAGE_MAPPINGS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/lineage-mappings";
    private static final String PORTS_TO_PROCESS_URL_TEMPLATE = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/processes/{2}/ports";
    private static final String PROCESSES_METHOD_NAME = "createOrUpdateProcesses";
    private static final String EXTERNAL_DATA_ENGINE_METHOD_NAME = "createExternalDataEngine";
    private static final String SCHEMA_TYPE_METHOD_NAME = "createOrUpdateSchemaType";
    private static final String PORT_IMPLEMENTATION_METHOD_NAME = "createOrUpdatePortImplementation";
    private static final String PORT_ALIAS_METHOD_NAME = "createOrUpdatePortAlias";
    private static final String LINEAGE_MAPPINGS_METHOD_NAME = "addLineageMappings";
    private static final String PORTS_TO_PROCESS_METHOD_NAME = "addPortsToProcess";
    private String serverPlatformRootURL;
    private String externalSourceName;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public DataEngineRESTClient(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
    }

    public DataEngineRESTClient(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
        this.serverName = serverName;
        this.serverPlatformRootURL = serverPlatformRootURL;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    @Override
    public List<String> createOrUpdateProcesses(String userId, List<Process> processes) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, PROCESSES_METHOD_NAME);
        ProcessesRequestBody requestBody = new ProcessesRequestBody();
        requestBody.setProcesses(processes);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callProcessListPostRESTCall(userId, PROCESSES_METHOD_NAME, PROCESS_URL_TEMPLATE, requestBody, new Object[0]);
    }

    @Override
    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, EXTERNAL_DATA_ENGINE_METHOD_NAME);
        DataEngineRegistrationRequestBody requestBody = new DataEngineRegistrationRequestBody();
        requestBody.setSoftwareServerCapability(softwareServerCapability);
        this.setExternalSourceName(softwareServerCapability.getQualifiedName());
        return this.callGUIDPostRESTCall(userId, EXTERNAL_DATA_ENGINE_METHOD_NAME, DATA_ENGINE_REGISTRATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, SCHEMA_TYPE_METHOD_NAME);
        SchemaTypeRequestBody requestBody = new SchemaTypeRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, SCHEMA_TYPE_METHOD_NAME, SCHEMA_TYPE_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, PortImplementation portImplementation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, PORT_IMPLEMENTATION_METHOD_NAME);
        PortImplementationRequestBody requestBody = new PortImplementationRequestBody();
        requestBody.setPortImplementation(portImplementation);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, PORT_IMPLEMENTATION_METHOD_NAME, PORT_IMPLEMENTATION_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, PortAlias portAlias) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = PORT_ALIAS_METHOD_NAME;
        this.invalidParameterHandler.validateUserId(userId, PORT_ALIAS_METHOD_NAME);
        PortAliasRequestBody requestBody = new PortAliasRequestBody();
        requestBody.setPortAlias(portAlias);
        requestBody.setExternalSourceName(this.externalSourceName);
        return this.callGUIDPostRESTCall(userId, PORT_ALIAS_METHOD_NAME, PORT_ALIAS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public void addLineageMappings(String userId, List<LineageMapping> lineageMappings) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = LINEAGE_MAPPINGS_METHOD_NAME;
        this.invalidParameterHandler.validateUserId(userId, LINEAGE_MAPPINGS_METHOD_NAME);
        LineageMappingsRequestBody requestBody = new LineageMappingsRequestBody();
        requestBody.setLineageMappings(lineageMappings);
        requestBody.setExternalSourceName(this.externalSourceName);
        this.callVoidPostRESTCall(userId, LINEAGE_MAPPINGS_METHOD_NAME, LINEAGE_MAPPINGS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, new Object[0]);
    }

    @Override
    public void addPortsToProcess(String userId, List<String> portQualifiedNames, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = PORTS_TO_PROCESS_METHOD_NAME;
        this.invalidParameterHandler.validateUserId(userId, PORTS_TO_PROCESS_METHOD_NAME);
        PortListRequestBody requestBody = new PortListRequestBody();
        requestBody.setPorts(portQualifiedNames);
        requestBody.setExternalSourceName(this.externalSourceName);
        this.callVoidPostRESTCall(userId, PORTS_TO_PROCESS_METHOD_NAME, PORTS_TO_PROCESS_URL_TEMPLATE, (DataEngineOMASAPIRequestBody)requestBody, processGUID);
    }

    private void callVoidPostRESTCall(String userId, String methodName, String urlTemplate, DataEngineOMASAPIRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        VoidResponse restResult = super.callVoidPostRESTCall(methodName, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
    }

    private String callGUIDPostRESTCall(String userId, String methodName, String urlTemplate, DataEngineOMASAPIRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GUIDResponse restResult = super.callGUIDPostRESTCall(methodName, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        return restResult.getGUID();
    }

    private List<String> callProcessListPostRESTCall(String userId, String methodName, String urlTemplate, ProcessesRequestBody requestBody, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        ProcessListResponse restResult = (ProcessListResponse)super.callPostRESTCall(methodName, ProcessListResponse.class, this.serverPlatformRootURL + urlTemplate, (Object)requestBody, new Object[]{this.serverName, userId, params});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        return restResult.getGUIDs();
    }
}

