/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.connectors.intopic.DataEngineInTopicClientConnector;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventType;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DataFileEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DatabaseEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessHierarchyEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.RelationalTableEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.SchemaTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class DataEngineEventClient
implements DataEngineClient {
    private final DataEngineInTopicClientConnector topicConnector;
    private String externalSource;
    private DeleteSemantic deleteSemantic = DeleteSemantic.SOFT;

    public DataEngineEventClient(DataEngineInTopicClientConnector dataEngineInTopicClientConnector) {
        this.topicConnector = dataEngineInTopicClientConnector;
    }

    public DeleteSemantic getDeleteSemantic() {
        return this.deleteSemantic;
    }

    public void setDeleteSemantic(DeleteSemantic deleteSemantic) {
        this.deleteSemantic = deleteSemantic;
    }

    @Override
    public String createOrUpdateProcess(String userId, Process process) throws InvalidParameterException, ConnectorCheckedException {
        ProcessEvent event = new ProcessEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PROCESS_EVENT);
        event.setProcess(process);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteProcess(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = new DeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DELETE_PROCESS_EVENT);
        event.setQualifiedName(qualifiedName);
        event.setGuid(guid);
        event.setDeleteSemantic(this.deleteSemantic);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, ConnectorCheckedException {
        DataEngineRegistrationEvent event = new DataEngineRegistrationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DATA_ENGINE_REGISTRATION_EVENT);
        event.setSoftwareServerCapability(softwareServerCapability);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteExternalDataEngine(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_DATA_ENGINE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, ConnectorCheckedException {
        SchemaTypeEvent event = new SchemaTypeEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.SCHEMA_TYPE_EVENT);
        event.setSchemaType(schemaType);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteSchemaType(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_SCHEMA_TYPE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, PortImplementation portImplementation, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortImplementationEvent event = new PortImplementationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PORT_IMPLEMENTATION_EVENT);
        event.setPortImplementation(portImplementation);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortImplementation(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_PORT_IMPLEMENTATION_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, PortAlias portAlias, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortAliasEvent event = new PortAliasEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PORT_ALIAS_EVENT);
        event.setPortAlias(portAlias);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortAlias(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_PORT_ALIAS_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String addProcessHierarchy(String userId, ProcessHierarchy processHierarchy) throws InvalidParameterException, ConnectorCheckedException {
        ProcessHierarchyEvent event = new ProcessHierarchyEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.PROCESS_HIERARCHY_EVENT);
        event.setProcessHierarchy(processHierarchy);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void addLineageMappings(String userId, List<LineageMapping> lineageMappings) throws InvalidParameterException, ConnectorCheckedException {
        LineageMappingsEvent event = new LineageMappingsEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.LINEAGE_MAPPINGS_EVENT);
        event.setLineageMappings(lineageMappings);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void setExternalSourceName(String externalSourceName) {
        this.externalSource = externalSourceName;
    }

    @Override
    public String getExternalSourceName() {
        return this.externalSource;
    }

    @Override
    public String upsertDatabase(String userId, Database database) throws InvalidParameterException, ConnectorCheckedException {
        DatabaseEvent event = new DatabaseEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DATABASE_EVENT);
        event.setDatabase(database);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertRelationalTable(String userId, RelationalTable relationalTable) throws InvalidParameterException, ConnectorCheckedException {
        RelationalTableEvent event = new RelationalTableEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.RELATIONAL_TABLE_EVENT);
        event.setRelationalTable(relationalTable);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertDataFile(String userId, DataFile dataFile) throws InvalidParameterException, ConnectorCheckedException {
        DataFileEvent event = new DataFileEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setEventType(DataEngineEventType.DATA_FILE_EVENT);
        event.setDataFile(dataFile);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteDatabase(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_DATABASE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteRelationalTable(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_RELATIONAL_TABLE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteDataFile(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_DATA_FILE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteFolder(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_FOLDER_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteConnection(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_CONNECTION_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteEndpoint(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setEventType(DataEngineEventType.DELETE_ENDPOINT_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    private DeleteEvent getDeleteEvent(String userId, String qualifiedName, String guid) {
        DeleteEvent event = new DeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setQualifiedName(qualifiedName);
        event.setGuid(guid);
        event.setDeleteSemantic(this.deleteSemantic);
        return event;
    }
}

