/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.connectors.intopic.DataEngineInTopicClientConnector;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventType;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DataFileEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DatabaseEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DatabaseSchemaEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.EventTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessHierarchyEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.RelationalTableEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.SchemaTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.TopicEvent;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DatabaseSchema;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.EventType;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.Topic;
import org.odpi.openmetadata.accessservices.dataengine.rest.FindRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;

public class DataEngineEventClient
implements DataEngineClient {
    private final DataEngineInTopicClientConnector topicConnector;
    private String externalSource;
    private DeleteSemantic deleteSemantic = DeleteSemantic.SOFT;

    public DataEngineEventClient(DataEngineInTopicClientConnector dataEngineInTopicClientConnector) {
        this.topicConnector = dataEngineInTopicClientConnector;
    }

    public DeleteSemantic getDeleteSemantic() {
        return this.deleteSemantic;
    }

    public void setDeleteSemantic(DeleteSemantic deleteSemantic) {
        this.deleteSemantic = deleteSemantic;
    }

    @Override
    public String createOrUpdateProcess(String userId, Process process) throws InvalidParameterException, ConnectorCheckedException {
        ProcessEvent event = new ProcessEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.PROCESS_EVENT);
        event.setProcess(process);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteProcess(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = new DeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.DELETE_PROCESS_EVENT);
        event.setQualifiedName(qualifiedName);
        event.setGuid(guid);
        event.setDeleteSemantic(this.deleteSemantic);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, ConnectorCheckedException {
        DataEngineRegistrationEvent event = new DataEngineRegistrationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.DATA_ENGINE_REGISTRATION_EVENT);
        event.setSoftwareServerCapability(softwareServerCapability);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteExternalDataEngine(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_DATA_ENGINE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdateSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, ConnectorCheckedException {
        SchemaTypeEvent event = new SchemaTypeEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.SCHEMA_TYPE_EVENT);
        event.setSchemaType(schemaType);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteSchemaType(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_SCHEMA_TYPE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortImplementation(String userId, PortImplementation portImplementation, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortImplementationEvent event = new PortImplementationEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.PORT_IMPLEMENTATION_EVENT);
        event.setPortImplementation(portImplementation);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortImplementation(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_PORT_IMPLEMENTATION_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String createOrUpdatePortAlias(String userId, PortAlias portAlias, String processQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        PortAliasEvent event = new PortAliasEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.PORT_ALIAS_EVENT);
        event.setPortAlias(portAlias);
        event.setProcessQualifiedName(processQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deletePortAlias(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_PORT_ALIAS_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public String addProcessHierarchy(String userId, ProcessHierarchy processHierarchy) throws InvalidParameterException, ConnectorCheckedException {
        ProcessHierarchyEvent event = new ProcessHierarchyEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.PROCESS_HIERARCHY_EVENT);
        event.setProcessHierarchy(processHierarchy);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void addLineageMappings(String userId, List<LineageMapping> lineageMappings) throws InvalidParameterException, ConnectorCheckedException {
        LineageMappingsEvent event = new LineageMappingsEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.LINEAGE_MAPPINGS_EVENT);
        event.setLineageMappings(lineageMappings);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void setExternalSourceName(String externalSourceName) {
        this.externalSource = externalSourceName;
    }

    @Override
    public String getExternalSourceName() {
        return this.externalSource;
    }

    @Override
    public String upsertDatabase(String userId, Database database) throws InvalidParameterException, ConnectorCheckedException {
        DatabaseEvent event = new DatabaseEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.DATABASE_EVENT);
        event.setDatabase(database);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertDatabaseSchema(String userId, DatabaseSchema databaseSchema, String databaseQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        DatabaseSchemaEvent event = new DatabaseSchemaEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.DATABASE_SCHEMA_EVENT);
        event.setDatabaseSchema(databaseSchema);
        event.setDatabaseQualifiedName(databaseQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertRelationalTable(String userId, RelationalTable relationalTable, String databaseSchemaQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        RelationalTableEvent event = new RelationalTableEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.RELATIONAL_TABLE_EVENT);
        event.setRelationalTable(relationalTable);
        event.setDatabaseSchemaQualifiedName(databaseSchemaQualifiedName);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertDataFile(String userId, DataFile dataFile) throws InvalidParameterException, ConnectorCheckedException {
        DataFileEvent event = new DataFileEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.DATA_FILE_EVENT);
        event.setDataFile(dataFile);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteDatabase(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_DATABASE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteDatabaseSchema(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_DATABASE_SCHEMA_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteRelationalTable(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_RELATIONAL_TABLE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteDataFile(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_DATA_FILE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteFolder(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_FOLDER_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteConnection(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_CONNECTION_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteEndpoint(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_ENDPOINT_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public GUIDListResponse find(String userId, FindRequestBody findRequestBody) throws FunctionNotSupportedException {
        String methodName = "find";
        throw new FunctionNotSupportedException(DataEngineErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
    }

    @Override
    public String upsertTopic(String userId, Topic topic) throws InvalidParameterException, ConnectorCheckedException {
        TopicEvent event = new TopicEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.TOPIC_EVENT);
        event.setTopic(topic);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public String upsertEventType(String userId, EventType eventType, String topicQualifiedName) throws InvalidParameterException, ConnectorCheckedException {
        EventTypeEvent event = new EventTypeEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setDataEngineEventType(DataEngineEventType.EVENT_TYPE_EVENT);
        event.setTopicQualifiedName(topicQualifiedName);
        event.setEventType(eventType);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
        return null;
    }

    @Override
    public void deleteTopic(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_TOPIC_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    @Override
    public void deleteEventType(String userId, String qualifiedName, String guid) throws InvalidParameterException, ConnectorCheckedException {
        DeleteEvent event = this.getDeleteEvent(userId, qualifiedName, guid);
        event.setDataEngineEventType(DataEngineEventType.DELETE_EVENT_TYPE_EVENT);
        this.topicConnector.sendEvent((DataEngineEventHeader)event);
    }

    private DeleteEvent getDeleteEvent(String userId, String qualifiedName, String guid) {
        DeleteEvent event = new DeleteEvent();
        event.setUserId(userId);
        event.setExternalSourceName(this.externalSource);
        event.setQualifiedName(qualifiedName);
        event.setGuid(guid);
        event.setDeleteSemantic(this.deleteSemantic);
        return event;
    }
}

