/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.client;

import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DataEngineRESTConfigurationClient
extends DataEngineRESTClient {
    private static final String IN_TOPIC_CONNECTION_PATH = "/servers/{0}/open-metadata/access-services/data-engine/users/{1}/topics/in-topic-connection";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public DataEngineRESTConfigurationClient(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformRootURL;
    }

    public DataEngineRESTConfigurationClient(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformRootURL;
    }

    public ConnectionResponse getInTopicConnection(String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getInTopicConnection";
        this.invalidParameterHandler.validateUserId(serverName, methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        return this.callOCFConnectionGetRESTCall(methodName, this.serverPlatformURLRoot + IN_TOPIC_CONNECTION_PATH, new Object[]{serverName, userId});
    }
}

