/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.dataengineproxy;

import java.text.MessageFormat;

public enum DataEngineConnectorErrorCode {
    OMAS_CONNECTION_ERROR(500, "DATA-ENGINE-CONNECTOR-500-001", "The Data Engine OMAS client was not successfully initialized", "The system is unable to process anything due to a lack of OMAS connectivity.", "Check your OMAS configuration is correct and the OMAS is running."),
    USER_NOT_AUTHORIZED(500, "DATA-ENGINE-CONNECTOR-500-002", "The user is not authorized for the Data Engine OMAS operation", "The system is unable to process the operation due to the user not being authorized to do so.", "Check your OMAS configuration and user authorizations."),
    UNKNOWN_ERROR(500, "DATA-ENGINE-CONNECTOR-500-003", "An unknown error occurred", "The system is unable to process the operation due to an unknown runtime error.", "Check your OMAS configuration and server logs to troubleshoot."),
    NO_CONFIG(404, "DATA-ENGINE-CONNECTOR-404-003", "No configuration was provided for the Data Engine Proxy server", "The system is unable to process the operation due to a lack of a configuration document.", "Check your configuration request and ensure all necessary information is provided and accurate.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private DataEngineConnectorErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

