/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.connectors;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.governanceservers.dataengineproxy.connectors.DataEngineInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataEngineConnectorBase
extends ConnectorBase
implements DataEngineInterface {
    private static final Logger log = LoggerFactory.getLogger(DataEngineConnectorBase.class);

    @Override
    public boolean requiresPolling() {
        return true;
    }

    @Override
    public Date getChangesLastSynced() {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::getChangesLastSynced() is not overridden (unimplemented), yet the connector requires polling.");
        }
        return null;
    }

    @Override
    public void setChangesLastSynced(Date time) {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::setChangesLastSynced(Date) is not overridden (unimplemented), yet the connector requires polling.");
        }
    }

    @Override
    public Date getOldestChangeSince(Date time) {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::getOldestChangeSince(Date) is not overridden (unimplemented), yet the connector requires polling.");
        }
        return null;
    }

    @Override
    public List<SchemaType> getChangedSchemaTypes(Date from, Date to) {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedSchemaTypes(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<PortImplementation> getChangedPortImplementations(Date from, Date to) {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedPortImplementations(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<PortAlias> getChangedPortAliases(Date from, Date to) {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedPortAliases(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<Process> getChangedProcesses(Date from, Date to) {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedProcesses(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<LineageMapping> getChangedLineageMappings(Date from, Date to) {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedLineageMappings(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }
}

