/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.connectors;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFlow;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.Referenceable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.dataengineproxy.connectors.DataEngineInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataEngineConnectorBase
extends ConnectorBase
implements DataEngineInterface {
    private static final Logger log = LoggerFactory.getLogger(DataEngineConnectorBase.class);

    @Override
    public boolean requiresPolling() {
        return true;
    }

    @Override
    public String getProcessingStateSyncKey() {
        log.warn("DataEngineConnectorBase::getProcessingStateSyncKey() is not overridden (unimplemented).");
        return null;
    }

    @Override
    public Date getChangesLastSynced() throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::getChangesLastSynced() is not overridden (unimplemented), yet the connector requires polling.");
        }
        return null;
    }

    @Override
    public void setChangesLastSynced(Date time) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::setChangesLastSynced(Date) is not overridden (unimplemented), yet the connector requires polling.");
        }
    }

    @Override
    public Date getOldestChangeSince(Date time) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.warn("DataEngineConnectorBase::getOldestChangeSince(Date) is not overridden (unimplemented), yet the connector requires polling.");
        }
        return null;
    }

    @Override
    public List<SchemaType> getChangedSchemaTypes(Date from, Date to) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedSchemaTypes(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<? super Referenceable> getChangedDataStores(Date from, Date to) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedDataStores(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<Process> getChangedProcesses(Date from, Date to) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedProcesses(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<ProcessHierarchy> getChangedProcessHierarchies(Date from, Date to) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedProcessHierarchies(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }

    @Override
    public List<DataFlow> getChangedDataFlows(Date from, Date to) throws ConnectorCheckedException, PropertyServerException {
        if (this.requiresPolling()) {
            log.debug("DataEngineConnectorBase::getChangedDataFlows(Date, Date) is not overridden (unimplemented).");
        }
        return Collections.emptyList();
    }
}

