/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.admin;

import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineImpl;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog.DataEngineProxyAuditCode;
import org.odpi.openmetadata.governanceservers.dataengineproxy.processor.DataEngineProxyChangePoller;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.dataengineproxy.DataEngineConnectorBase;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineProxyOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineProxyOperationalServices.class);
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private OMRSAuditLog auditLog;
    private DataEngineConnectorBase dataEngineConnector;
    private DataEngineProxyChangePoller changePoller;

    public DataEngineProxyOperationalServices(String localServerName, String localServerUserId, String localServerPassword) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DataEngineProxyConfig dataEngineProxyConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        DataEngineImpl dataEngineClient;
        String methodName = "initialize";
        String actionDescription = "initialize";
        DataEngineProxyAuditCode auditCode = DataEngineProxyAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = auditLog;
        if (dataEngineProxyConfig == null) {
            auditCode = DataEngineProxyAuditCode.NO_CONFIG_DOC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", auditCode.getFormattedLogMessage(this.localServerName), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        if (dataEngineProxyConfig.getAccessServiceRootURL() == null) {
            auditCode = DataEngineProxyAuditCode.NO_OMAS_SERVER_URL;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", auditCode.getFormattedLogMessage(this.localServerName), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        if (dataEngineProxyConfig.getAccessServiceServerName() == null) {
            auditCode = DataEngineProxyAuditCode.NO_OMAS_SERVER_NAME;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", auditCode.getFormattedLogMessage(this.localServerName), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        try {
            dataEngineClient = new DataEngineImpl(dataEngineProxyConfig.getAccessServiceServerName(), dataEngineProxyConfig.getAccessServiceRootURL(), this.localServerUserId, this.localServerPassword);
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedHTTPCode(), this.getClass().getName(), "initialize", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), (Throwable)error);
        }
        Connection dataEngineConnection = dataEngineProxyConfig.getDataEngineConnection();
        if (dataEngineConnection != null) {
            log.info("Found connection, attempting to retrieve connector via broker.");
            try {
                ConnectorBroker connectorBroker = new ConnectorBroker();
                this.dataEngineConnector = (DataEngineConnectorBase)connectorBroker.getConnector(dataEngineConnection);
                if (this.dataEngineConnector.requiresPolling()) {
                    this.changePoller = new DataEngineProxyChangePoller(this.dataEngineConnector, dataEngineProxyConfig, dataEngineClient, auditLog);
                    this.changePoller.start();
                }
            }
            catch (ConnectionCheckedException | ConnectorCheckedException e) {
                log.error("Unable to initialize connector.", e);
                auditCode = DataEngineProxyAuditCode.ERROR_INITIALIZING_CONNECTION;
                this.auditLog.logRecord("ChangePoller construction", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), e.getErrorMessage(), auditCode.getSystemAction(), auditCode.getUserAction());
            }
            finally {
                this.changePoller.stop();
            }
        }
        log.info("Data Engine Proxy has been started!");
    }

    public boolean disconnect(boolean permanent) {
        try {
            if (this.changePoller != null) {
                this.changePoller.stop();
            }
            this.dataEngineConnector.disconnect();
            DataEngineProxyAuditCode auditCode = DataEngineProxyAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        catch (Exception e) {
            DataEngineProxyAuditCode auditCode = DataEngineProxyAuditCode.ERROR_SHUTDOWN;
            this.auditLog.logRecord("Disconnecting", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return false;
        }
    }
}

