/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.admin;

import java.text.MessageFormat;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineImpl;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog.DataEngineProxyAuditCode;
import org.odpi.openmetadata.governanceservers.dataengineproxy.connectors.DataEngineConnectorBase;
import org.odpi.openmetadata.governanceservers.dataengineproxy.processor.DataEngineProxyChangePoller;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DataEngineProxyOperationalServices {
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private OMRSAuditLog auditLog;
    private DataEngineConnectorBase dataEngineConnector;
    private DataEngineProxyChangePoller changePoller;

    public DataEngineProxyOperationalServices(String localServerName, String localServerUserId, String localServerPassword) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DataEngineProxyConfig dataEngineProxyConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        DataEngineImpl dataEngineClient;
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize", DataEngineProxyAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        if (dataEngineProxyConfig == null) {
            AuditLogMessageDefinition error = DataEngineProxyAuditCode.NO_CONFIG_DOC.getMessageDefinition(this.localServerName);
            auditLog.logMessage("initialize", error);
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", MessageFormat.format(error.getMessageTemplate(), error.getMessageParams()), error.getSystemAction(), error.getUserAction());
        }
        if (dataEngineProxyConfig.getAccessServiceRootURL() == null) {
            AuditLogMessageDefinition error = DataEngineProxyAuditCode.NO_OMAS_SERVER_URL.getMessageDefinition(this.localServerName);
            auditLog.logMessage("initialize", error);
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", MessageFormat.format(error.getMessageTemplate(), error.getMessageParams()), error.getSystemAction(), error.getUserAction());
        }
        if (dataEngineProxyConfig.getAccessServiceServerName() == null) {
            AuditLogMessageDefinition error = DataEngineProxyAuditCode.NO_OMAS_SERVER_NAME.getMessageDefinition(this.localServerName);
            auditLog.logMessage("initialize", error);
            throw new OMAGConfigurationErrorException(500, this.getClass().getName(), "initialize", MessageFormat.format(error.getMessageTemplate(), error.getMessageParams()), error.getSystemAction(), error.getUserAction());
        }
        try {
            dataEngineClient = this.localServerName != null && this.localServerPassword != null ? new DataEngineImpl(dataEngineProxyConfig.getAccessServiceServerName(), dataEngineProxyConfig.getAccessServiceRootURL(), this.localServerUserId, this.localServerPassword) : new DataEngineImpl(dataEngineProxyConfig.getAccessServiceServerName(), dataEngineProxyConfig.getAccessServiceRootURL());
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedHTTPCode(), this.getClass().getName(), "initialize", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), (Throwable)error);
        }
        Connection dataEngineConnection = dataEngineProxyConfig.getDataEngineConnection();
        if (dataEngineConnection != null) {
            try {
                ConnectorBroker connectorBroker = new ConnectorBroker();
                this.dataEngineConnector = (DataEngineConnectorBase)connectorBroker.getConnector(dataEngineConnection);
                this.dataEngineConnector.start();
                if (this.dataEngineConnector.requiresPolling()) {
                    this.changePoller = new DataEngineProxyChangePoller(this.dataEngineConnector, this.localServerUserId, dataEngineProxyConfig, dataEngineClient, auditLog);
                    this.changePoller.start();
                }
            }
            catch (ConnectionCheckedException | ConnectorCheckedException e) {
                this.auditLog.logException("initialize", DataEngineProxyAuditCode.ERROR_INITIALIZING_CONNECTION.getMessageDefinition(), e);
            }
            finally {
                this.changePoller.stop();
            }
        }
        if (this.dataEngineConnector != null && this.dataEngineConnector.isActive()) {
            this.auditLog.logMessage("initialize", DataEngineProxyAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.dataEngineConnector.getConnection().getConnectorType().getConnectorProviderClassName()));
        } else {
            this.auditLog.logMessage("initialize", DataEngineProxyAuditCode.NO_CONFIG_DOC.getMessageDefinition());
        }
    }

    public boolean disconnect(boolean permanent) {
        String methodName = "disconnect";
        try {
            if (this.changePoller != null) {
                this.changePoller.stop();
            }
            this.dataEngineConnector.disconnect();
            this.auditLog.logMessage("disconnect", DataEngineProxyAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.localServerName));
            return true;
        }
        catch (Exception e) {
            this.auditLog.logException("disconnect", DataEngineProxyAuditCode.ERROR_SHUTDOWN.getMessageDefinition(), (Throwable)e);
            return false;
        }
    }
}

