/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataEngineProxyErrorCode implements ExceptionMessageSet
{
    NO_CONFIG_DOC(500, "DATA-ENGINE-PROXY-500-001", "Data Engine proxy {0} is not configured with a configuration document", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration document for this data engine proxy."),
    NO_OMAS_SERVER_URL(500, "DATA-ENGINE-PROXY-500-002", "Data Engine proxy {0} is not configured with the platform URL root for the Data Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the platform URL root to this data engine proxy's configuration document."),
    NO_OMAS_SERVER_NAME(500, "DATA-ENGINE-PROXY-500-003", "Data Engine proxy {0} is not configured with the name for the server running the Data Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the server name to this data engine proxy's configuration document."),
    INVALID_PARAMETER(500, "DATA-ENGINE-PROXY-500-004", "Data Engine proxy {0} could not be initialized due to an invalid parameter", "The server is not able to initialize.  It fails to start.", "Review the logs for more information on the invalid parameter exception.");

    private ExceptionMessageDefinition messageDefinition;

    private DataEngineProxyErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

