/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum DataEngineProxyAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("DATA-ENGINE-PROXY-0001", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy is initializing a new server instance", "The local server has started up a new instance of the Data Engine Proxy.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("DATA-ENGINE-PROXY-0005", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy has initialized a new instance for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    INIT_POLLING("DATA-ENGINE-PROXY-0006", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy is initializing polling for changes", "The local server has started up a new change poller for the Data Engine Proxy.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("DATA-ENGINE-PROXY-0007", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy is shutting down its instance for server {0}", "The local server has requested shut down of a Data Engine Proxy instance.", "No action is required.  This is part of the normal operation of the service."),
    ERROR_SHUTDOWN("DATA-ENGINE-PROXY-0008", OMRSAuditLogRecordSeverity.EXCEPTION, "The service is not shutdown properly.", "The connection could not be shutdown.", "Try again. "),
    POLLING("DATA-ENGINE-PROXY-0009", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy is polling for changes between {0} and {1}", "The local server is looking for changes since the last poll interval.", "No action is required.  This is part of the normal operation of the service."),
    OMAS_CONNECTION_ERROR("DATA-ENGINE-PROXY-0010", OMRSAuditLogRecordSeverity.EXCEPTION, "The Data Engine OMAS client was not successfully initialized", "The system is unable to process anything due to a lack of OMAS connectivity.", "Check your OMAS configuration is correct and the OMAS is running."),
    USER_NOT_AUTHORIZED("DATA-ENGINE-PROXY-0011", OMRSAuditLogRecordSeverity.ERROR, "The user is not authorized for the Data Engine OMAS operation: {0}", "The system is unable to process the operation due to the user not being authorized to do so.", "Check your OMAS configuration and user authorizations."),
    POLLING_TYPE_START("DATA-ENGINE-PROXY-0012", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy is polling for changes to {0}", "The local server is looking for changes to the specified information since the last poll interval.", "No action is required.  This is part of the normal operation of the service."),
    POLLING_TYPE_FINISH("DATA-ENGINE-PROXY-0013", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Proxy has completed polling for changes to {0}", "The local server has completed looking for changes to the specified type since the last poll interval.", "No action is required.  This is part of the normal operation of the service.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private DataEngineProxyAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }
}

