/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataEngineProxyErrorCode implements ExceptionMessageSet
{
    NO_CONFIG_DOC(500, "DATA-ENGINE-PROXY-500-001", "Data Engine proxy {0} is not configured with a configuration document", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration document for this data engine proxy."),
    NO_OMAS_SERVER_URL(500, "DATA-ENGINE-PROXY-500-002", "Data Engine proxy {0} is not configured with the platform URL root for the Data Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the platform URL root to this data engine proxy's configuration document."),
    NO_OMAS_SERVER_NAME(500, "DATA-ENGINE-PROXY-500-003", "Data Engine proxy {0} is not configured with the name for the server running the Data Engine OMAS", "The server is not able to retrieve its configuration.  It fails to start.", "Add the configuration for the server name to this data engine proxy's configuration document."),
    ERROR_INITIALIZING_CONNECTION(500, "DATA-ENGINE-PROXY-500-005", "Unable to initialize the Data Engine connection", "The connection could not be initialized.", "Review the exception and resolve the configuration. "),
    ERROR_INITIALIZING_CLIENT_CONNECTION(500, "DATA-ENGINE-PROXY-500-006", "Unable to initialize the Data Engine client connection", "The client connection could not be initialized.", "Review the exception and resolve the configuration."),
    UNKNOWN_ERROR(500, "DATA-ENGINE-PROXY-500-008", "An unknown error occurred", "The system is unable to process the operation due to an unknown runtime error.", "Check your OMAS configuration and server logs to troubleshoot.");

    private ExceptionMessageDefinition messageDefinition;

    private DataEngineProxyErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "DataEngineProxyErrorCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

