/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.admin;

import java.util.ArrayList;
import java.util.Map;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineClient;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineEventClient;
import org.odpi.openmetadata.accessservices.dataengine.client.DataEngineRESTConfigurationClient;
import org.odpi.openmetadata.accessservices.dataengine.connectors.intopic.DataEngineInTopicClientConnector;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog.DataEngineProxyAuditCode;
import org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog.DataEngineProxyErrorCode;
import org.odpi.openmetadata.governanceservers.dataengineproxy.connectors.DataEngineConnectorBase;
import org.odpi.openmetadata.governanceservers.dataengineproxy.processor.DataEngineProxyChangePoller;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;

public class DataEngineProxyOperationalServices {
    private String localServerName;
    private String localServerId;
    private String localServerUserId;
    private String localServerPassword;
    private OMRSAuditLog auditLog;
    private DataEngineConnectorBase dataEngineConnector;
    private DataEngineProxyChangePoller changePoller;
    private DataEngineInTopicClientConnector dataEngineTopicConnector;

    public DataEngineProxyOperationalServices(String localServerName, String localServerId, String localServerUserId, String localServerPassword) {
        this.localServerName = localServerName;
        this.localServerId = localServerId;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
    }

    public void initialize(DataEngineProxyConfig dataEngineProxyConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        Connection dataEngineConnection;
        ConnectorBroker connectorBroker;
        DataEngineRESTConfigurationClient dataEngineClient;
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize", DataEngineProxyAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        if (dataEngineProxyConfig == null) {
            throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.NO_CONFIG_DOC.getMessageDefinition(this.localServerName), this.getClass().getName(), "initialize");
        }
        if (dataEngineProxyConfig.getAccessServiceRootURL() == null) {
            throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.NO_OMAS_SERVER_URL.getMessageDefinition(this.localServerName), this.getClass().getName(), "initialize");
        }
        if (dataEngineProxyConfig.getAccessServiceServerName() == null) {
            throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.NO_OMAS_SERVER_NAME.getMessageDefinition(this.localServerName), this.getClass().getName(), "initialize");
        }
        try {
            dataEngineClient = this.localServerName != null && this.localServerPassword != null ? new DataEngineRESTConfigurationClient(dataEngineProxyConfig.getAccessServiceServerName(), dataEngineProxyConfig.getAccessServiceRootURL(), this.localServerUserId, this.localServerPassword) : new DataEngineRESTConfigurationClient(dataEngineProxyConfig.getAccessServiceServerName(), dataEngineProxyConfig.getAccessServiceRootURL());
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.UNKNOWN_ERROR.getMessageDefinition(), this.getClass().getName(), "initialize", (Throwable)error);
        }
        if (dataEngineProxyConfig.isEventsClientEnabled()) {
            try {
                ConnectionResponse connectionResponse = dataEngineClient.getInTopicConnection(dataEngineProxyConfig.getAccessServiceServerName(), this.localServerUserId);
                connectorBroker = new ConnectorBroker((AuditLog)auditLog);
                VirtualConnection virtualConnection = (VirtualConnection)connectionResponse.getConnection();
                ArrayList embeddedConnections = new ArrayList();
                virtualConnection.getEmbeddedConnections().forEach(embeddedConnection -> {
                    Connection connection = embeddedConnection.getEmbeddedConnection();
                    Map cp = connection.getConfigurationProperties();
                    cp.put("local.server.id", this.localServerId);
                    connection.setConfigurationProperties(cp);
                    embeddedConnection.setEmbeddedConnection(connection);
                    embeddedConnections.add(embeddedConnection);
                });
                virtualConnection.setEmbeddedConnections(embeddedConnections);
                this.dataEngineTopicConnector = (DataEngineInTopicClientConnector)connectorBroker.getConnector((Connection)virtualConnection);
                this.dataEngineTopicConnector.start();
                dataEngineClient = new DataEngineEventClient(this.dataEngineTopicConnector);
            }
            catch (ConnectionCheckedException | ConnectorCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.ERROR_INITIALIZING_CLIENT_CONNECTION.getMessageDefinition(), this.getClass().getName(), "initialize", e);
            }
        }
        if ((dataEngineConnection = dataEngineProxyConfig.getDataEngineConnection()) != null) {
            try {
                connectorBroker = new ConnectorBroker((AuditLog)auditLog);
                this.dataEngineConnector = (DataEngineConnectorBase)connectorBroker.getConnector(dataEngineConnection);
                this.dataEngineConnector.start();
                if (this.dataEngineConnector.requiresPolling()) {
                    this.changePoller = new DataEngineProxyChangePoller(this.dataEngineConnector, this.localServerUserId, dataEngineProxyConfig, (DataEngineClient)dataEngineClient, auditLog);
                    this.changePoller.start();
                }
            }
            catch (ConnectionCheckedException | ConnectorCheckedException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.ERROR_INITIALIZING_CONNECTION.getMessageDefinition(), this.getClass().getName(), "initialize", e);
            }
            finally {
                if (this.changePoller != null) {
                    this.changePoller.stop();
                }
            }
        }
        if (this.dataEngineConnector == null || !this.dataEngineConnector.isActive()) {
            throw new OMAGConfigurationErrorException(DataEngineProxyErrorCode.NO_CONFIG_DOC.getMessageDefinition(this.localServerName), this.getClass().getName(), "initialize");
        }
        this.auditLog.logMessage("initialize", DataEngineProxyAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.dataEngineConnector.getConnection().getConnectorType().getConnectorProviderClassName()));
    }

    public boolean disconnect() {
        String methodName = "disconnect";
        try {
            if (this.changePoller != null) {
                this.changePoller.stop();
            }
            if (this.dataEngineConnector != null) {
                this.dataEngineConnector.disconnect();
            }
            if (this.dataEngineTopicConnector != null) {
                this.dataEngineTopicConnector.disconnect();
            }
            this.auditLog.logMessage("disconnect", DataEngineProxyAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.localServerName));
            return true;
        }
        catch (Exception e) {
            this.auditLog.logException("disconnect", DataEngineProxyAuditCode.ERROR_SHUTDOWN.getMessageDefinition(), (Throwable)e);
            return false;
        }
    }
}

