/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.dataengineproxy.rest;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.dataengineproxy.auditlog.DataEngineProxyException;
import org.odpi.openmetadata.governanceservers.dataengineproxy.model.ProcessLoadResponse;
import org.odpi.openmetadata.governanceservers.dataengineproxy.processor.DataEngineProxyService;
import org.odpi.openmetadata.governanceservers.dataengineproxy.rest.DataEngineProxyInstanceHandler;

public class DataEngineProxyRestService {
    private final DataEngineProxyInstanceHandler instanceHandler = new DataEngineProxyInstanceHandler();
    AtomicBoolean isRunning = new AtomicBoolean(false);

    public ProcessLoadResponse load(String serverName, String userId) {
        String serviceOperationName = "DataEngineProxy";
        try {
            if (this.isRunning.get()) {
                return new ProcessLoadResponse();
            }
            DataEngineProxyService dataEngineProxyService = this.instanceHandler.getDataEngineProxyService(userId, serverName, serviceOperationName);
            this.isRunning.set(true);
            CompletableFuture.runAsync(dataEngineProxyService::load).thenAccept(result -> this.isRunning.set(false));
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException | DataEngineProxyException e) {
            ProcessLoadResponse response = new ProcessLoadResponse();
            response.setRelatedHTTPCode(e.getReportedHTTPCode());
            response.setExceptionClassName(e.getClass().getName());
            response.setExceptionErrorMessage(e.getReportedErrorMessage());
            response.setExceptionSystemAction(e.getReportedSystemAction());
            response.setExceptionUserAction(e.getReportedUserAction());
            return response;
        }
        return new ProcessLoadResponse();
    }

    public ProcessLoadResponse getProcessChanges(String serverName, String userId, String processId) {
        String serviceOperationName = "DataEngineProxy";
        try {
            DataEngineProxyService dataEngineProxyService = this.instanceHandler.getDataEngineProxyService(userId, serverName, serviceOperationName);
            dataEngineProxyService.pollProcessChanges(processId);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException | DataEngineProxyException e) {
            ProcessLoadResponse response = new ProcessLoadResponse();
            response.setRelatedHTTPCode(e.getReportedHTTPCode());
            response.setExceptionClassName(e.getClass().getName());
            response.setExceptionErrorMessage(e.getReportedErrorMessage());
            response.setExceptionSystemAction(e.getReportedSystemAction());
            response.setExceptionUserAction(e.getReportedUserAction());
            return response;
        }
        return new ProcessLoadResponse();
    }
}

