/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import org.odpi.openmetadata.accessservices.dataengine.server.auditlog.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineAdmin
implements AccessServiceAdmin {
    private OMRSAuditLog auditLog;
    private DataEngineServicesInstance instance;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) {
        String actionDescription = "initialize";
        try {
            DataEngineAuditCode auditCode = DataEngineAuditCode.SERVICE_INITIALIZING;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.auditLog = auditLog;
            this.instance = new DataEngineServicesInstance(repositoryConnector);
            String serverName = this.instance.getServerName();
            auditCode = DataEngineAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (Throwable error) {
            DataEngineAuditCode auditCode = DataEngineAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            DataEngineAuditCode auditCode = DataEngineAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }
}

