/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import org.odpi.openmetadata.accessservices.dataengine.exception.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRegistration;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineServicesInstanceMap;
import org.odpi.openmetadata.accessservices.dataengine.server.util.DataEngineErrorHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class DataEngineInstanceHandler {
    private final DataEngineErrorHandler dataEngineErrorHandler = new DataEngineErrorHandler();
    private static DataEngineServicesInstanceMap instanceMap = new DataEngineServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.DATA_ENGINE_OMAS;

    DataEngineInstanceHandler() {
        DataEngineRegistration.registerAccessService();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        DataEngineServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        this.dataEngineErrorHandler.handlePropertyServerException(DataEngineErrorCode.SERVICE_NOT_INITIALIZED, "getMetadataCollection");
        return null;
    }

    OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        DataEngineServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        this.dataEngineErrorHandler.handlePropertyServerException(DataEngineErrorCode.SERVICE_NOT_INITIALIZED, "getRepositoryConnector");
        return null;
    }

    String getAccessServiceName() {
        return myDescription.getAccessServiceName();
    }
}

