/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.exception.DataEngineException;
import org.odpi.openmetadata.accessservices.dataengine.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.dataengine.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineOMASAPIResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.service.ProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.util.DataEngineErrorHandler;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineRestServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRestServices.class);
    private DataEngineErrorHandler exceptionUtil = new DataEngineErrorHandler();
    private DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createProcess(String userId, String serverName, ProcessRequestBody processRequestBody) {
        String methodName = "createProcess";
        log.debug("Calling method: createProcess");
        GUIDResponse response = new GUIDResponse();
        try {
            ProcessHandler processHandler = new ProcessHandler(this.instanceHandler.getAccessServiceName(), this.instanceHandler.getRepositoryConnector(serverName), this.instanceHandler.getMetadataCollection(serverName));
            if (processRequestBody == null) {
                return null;
            }
            String processName = processRequestBody.getName();
            List inputs = processRequestBody.getInputs();
            List outputs = processRequestBody.getOutputs();
            String description = processRequestBody.getDescription();
            String latestChange = processRequestBody.getLatestChange();
            List zoneMembership = processRequestBody.getZoneMembership();
            String parentProcessGuid = processRequestBody.getParentProcessGuid();
            String displayName = processRequestBody.getDisplayName();
            String processGuid = processHandler.createProcess(userId, processName, description, latestChange, zoneMembership, displayName, parentProcessGuid);
            processHandler.addInputRelationships(userId, processGuid, inputs);
            processHandler.addOutputRelationships(userId, processGuid, outputs);
            response.setGuid(processGuid);
        }
        catch (ClassificationErrorException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            this.exceptionUtil.captureOMRSCheckedExceptionBase((DataEngineOMASAPIResponse)response, (OMRSCheckedExceptionBase)e);
        }
        catch (PropertyServerException | UserNotAuthorizedException e) {
            this.exceptionUtil.captureDataEngineException((DataEngineOMASAPIResponse)response, (DataEngineException)e);
        }
        return response;
    }
}

