/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import org.odpi.openmetadata.accessservices.dataengine.exception.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.exception.NewInstanceException;
import org.odpi.openmetadata.accessservices.dataengine.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineServicesInstanceMap;
import org.odpi.openmetadata.accessservices.dataengine.server.util.DataEngineErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineServicesInstance {
    private final DataEngineErrorHandler dataEngineErrorHandler = new DataEngineErrorHandler();
    private OMRSRepositoryConnector repositoryConnector;
    private OMRSMetadataCollection metadataCollection;
    private String serverName;

    public DataEngineServicesInstance(OMRSRepositoryConnector repositoryConnector) throws NewInstanceException {
        String methodName = "new ServiceInstance";
        if (repositoryConnector != null) {
            try {
                this.repositoryConnector = repositoryConnector;
                this.serverName = repositoryConnector.getServerName();
                this.metadataCollection = repositoryConnector.getMetadataCollection();
                DataEngineServicesInstanceMap.setNewInstanceForJVM(this.serverName, this);
            }
            catch (Throwable error) {
                this.dataEngineErrorHandler.handleNewInstanceException(DataEngineErrorCode.OMRS_NOT_INITIALIZED, "new ServiceInstance");
            }
        } else {
            this.dataEngineErrorHandler.handleNewInstanceException(DataEngineErrorCode.OMRS_NOT_INITIALIZED, "new ServiceInstance");
        }
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        this.dataEngineErrorHandler.handleNewInstanceException(DataEngineErrorCode.OMRS_NOT_AVAILABLE, "getServerName");
        return null;
    }

    OMRSMetadataCollection getMetadataCollection() throws PropertyServerException {
        String methodName = "getMetadataCollection";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.metadataCollection;
        }
        this.dataEngineErrorHandler.handlePropertyServerException(DataEngineErrorCode.OMRS_NOT_AVAILABLE, "getMetadataCollection");
        return null;
    }

    OMRSRepositoryConnector getRepositoryConnector() throws PropertyServerException {
        String methodName = "getRepositoryConnector";
        if (this.repositoryConnector != null && this.metadataCollection != null && this.repositoryConnector.isActive()) {
            return this.repositoryConnector;
        }
        this.dataEngineErrorHandler.handlePropertyServerException(DataEngineErrorCode.OMRS_NOT_AVAILABLE, "getRepositoryConnector");
        return null;
    }

    public void shutdown() {
        DataEngineServicesInstanceMap.removeInstanceForJVM(this.serverName);
    }
}

