/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.dataengine.server.util.DataEngineErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.springframework.util.StringUtils;

class ProcessHandler {
    private static final String PROCESS_PROPERTY_NAME = "name";
    private static final String QUALIFIED_NAME_PROPERTY_NAME = "qualifiedName";
    private static final String PROCESS_TYPE_NAME = "Process";
    private static final String PROCESS_INPUT_RELATIONSHIP_TYPE_NAME = "ProcessInput";
    private static final String PROCESS_OUTPUT_RELATIONSHIP_TYPE_NAME = "ProcessOutput";
    private static final String OWNER_PROPERTY_NAME = "owner";
    private static final String LATEST_CHANGE_PROPERTY_NAME = "latestChange";
    private static final String DESCRIPTION_PROPERTY_NAME = "description";
    private static final String DISPLAY_NAME_PROPERTY_NAME = "displayName";
    private static final String PARENT_PROCESS_GUID_PROPERTY_NAME = "parentProcessGuid";
    private static final String ZONE_MEMBERSHIP_PROPERTY_NAME = "zoneMembership";
    private OMRSMetadataCollection metadataCollection;
    private DataEngineErrorHandler errorHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private String serviceName;

    ProcessHandler(String serviceName, OMRSRepositoryConnector repositoryConnector, OMRSMetadataCollection metadataCollection) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.metadataCollection = metadataCollection;
        }
        this.errorHandler = new DataEngineErrorHandler();
    }

    String createProcess(String userId, String processName, String description, String latestChange, List<String> zoneMembership, String displayName, String parentProcessGuid) throws UserNotAuthorizedException, TypeErrorException, ClassificationErrorException, StatusNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, FunctionNotSupportedException {
        String methodName = "createProcess";
        this.errorHandler.validateUserId(userId, "createProcess");
        EntityDetail entity = this.repositoryHelper.getSkeletonEntity(this.serviceName, "", InstanceProvenanceType.LOCAL_COHORT, userId, PROCESS_TYPE_NAME);
        InstanceProperties instanceProperties = this.createProcessProperties(userId, processName, description, latestChange, zoneMembership, displayName);
        EntityDetail createdEntity = this.metadataCollection.addEntity(userId, entity.getType().getTypeDefGUID(), instanceProperties, entity.getClassifications(), entity.getStatus());
        return createdEntity.getGUID();
    }

    private InstanceProperties createProcessProperties(String userId, String processName, String description, String latestChange, List<String> zoneMembership, String displayName) {
        String methodName = "createProcessProperties";
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, PROCESS_PROPERTY_NAME, processName, "createProcessProperties");
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, QUALIFIED_NAME_PROPERTY_NAME, processName + ":" + new Date().toString(), "createProcessProperties");
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, DESCRIPTION_PROPERTY_NAME, description, "createProcessProperties");
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, LATEST_CHANGE_PROPERTY_NAME, latestChange, "createProcessProperties");
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OWNER_PROPERTY_NAME, userId, "createProcessProperties");
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, DISPLAY_NAME_PROPERTY_NAME, displayName, "createProcessProperties");
        this.addZoneMembershipToInstance(zoneMembership, properties);
        return properties;
    }

    private void addZoneMembershipToInstance(List<String> zoneMembership, InstanceProperties properties) {
        if (StringUtils.isEmpty(zoneMembership)) {
            return;
        }
        if (properties == null) {
            properties = new InstanceProperties();
        }
        ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
        arrayPropertyValue.setArrayCount(zoneMembership.size());
        for (String zone : zoneMembership) {
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)zone);
            arrayPropertyValue.setArrayValue(zoneMembership.indexOf(zone), (InstancePropertyValue)primitivePropertyValue);
        }
        properties.setProperty(ZONE_MEMBERSHIP_PROPERTY_NAME, (InstancePropertyValue)arrayPropertyValue);
    }

    void addInputRelationships(String userId, String processGuid, List<String> inputs) throws UserNotAuthorizedException, TypeErrorException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, PropertyErrorException {
        String methodName = "addInputRelationship";
        if (inputs == null) {
            return;
        }
        for (String dataSetGuid : inputs) {
            this.addRelationship(userId, processGuid, dataSetGuid, PROCESS_INPUT_RELATIONSHIP_TYPE_NAME, "addInputRelationship");
        }
    }

    void addOutputRelationships(String userId, String processGuid, List<String> outputs) throws UserNotAuthorizedException, TypeErrorException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, EntityNotKnownException, InvalidParameterException, RepositoryErrorException, PropertyErrorException {
        String methodName = "addOutputRelationship";
        if (outputs == null) {
            return;
        }
        for (String dataSetGuid : outputs) {
            this.addRelationship(userId, processGuid, dataSetGuid, PROCESS_OUTPUT_RELATIONSHIP_TYPE_NAME, "addOutputRelationship");
        }
    }

    private void addRelationship(String userId, String processGuid, String dataSetGuid, String relationshipType, String methodName) throws TypeErrorException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException, UserNotAuthorizedException {
        this.errorHandler.validateUserId(userId, methodName);
        Relationship relationship = this.repositoryHelper.getSkeletonRelationship(this.serviceName, "", InstanceProvenanceType.LOCAL_COHORT, userId, relationshipType);
        this.metadataCollection.addRelationship(userId, relationship.getType().getTypeDefGUID(), null, processGuid, dataSetGuid, InstanceStatus.ACTIVE);
    }
}

