/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataEngineAuditCode {
    SERVICE_INITIALIZING("OMAS-DATA-ENGINE-0001", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Data Engine OMAS.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMAS-DATA-ENGINE-0002", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Data Engine OMAS has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMAS-DATA-ENGINE-0003", OMRSAuditLogRecordSeverity.INFO, "The Data Engine Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local server has requested shut down of an Data Engine OMAS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-DATA-ENGINE-0005", OMRSAuditLogRecordSeverity.ERROR, "The Data Engine Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ERROR_INITIALIZING_TOPIC_CONNECTION("OMAS-DATA-ENGINE-0006", OMRSAuditLogRecordSeverity.ERROR, "The Data Engine Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private final String logMessageId;
    private final OMRSAuditLogRecordSeverity severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;
    private static final Logger log;

    private DataEngineAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        log.debug("<== DataEngine Audit Code.getMessage({})", (Object)Arrays.toString(params));
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        log.debug("==> DataEngine Audit Code.getMessage({}): {}", (Object)Arrays.toString(params), (Object)result);
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(DataEngineAuditCode.class);
    }
}

