/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.PortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.ProcessHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class DataEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRESTServices.class);
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createExternalDataEngine(String serverName, String userId, DataEngineRegistrationRequestBody requestBody) {
        String methodName = "createExternalDataEngine";
        log.debug("Calling method: {}", (Object)"createExternalDataEngine");
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataEngine", serverName);
                return response;
            }
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataEngine");
            SoftwareServerCapability softwareServerCapability = requestBody.getSoftwareServerCapability();
            response.setGUID(handler.createExternalDataEngine(userId, softwareServerCapability.getQualifiedName(), softwareServerCapability.getDisplayName(), softwareServerCapability.getDescription(), softwareServerCapability.getEngineType(), softwareServerCapability.getEngineVersion(), softwareServerCapability.getPatchLevel(), softwareServerCapability.getSource()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createExternalDataEngine", (Object)response.toString());
        return response;
    }

    public GUIDResponse getExternalDataEngineByQualifiedName(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataEngineByQualifiedName";
        log.debug("Calling method: {}", (Object)"getExternalDataEngineByQualifiedName");
        GUIDResponse response = new GUIDResponse();
        try {
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataEngineByQualifiedName");
            response.setGUID(handler.getExternalDataEngineByQualifiedName(userId, qualifiedName));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"getExternalDataEngineByQualifiedName", (Object)response.toString());
        return response;
    }

    public GUIDResponse createOrUpdateSchemaType(String userId, String serverName, SchemaTypeRequestBody schemaTypeRequestBody) {
        String methodName = "createOrUpdateSchemaType";
        log.debug("Calling method: {}", (Object)"createOrUpdateSchemaType");
        GUIDResponse response = new GUIDResponse();
        try {
            if (schemaTypeRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdateSchemaType", serverName);
                return response;
            }
            String newSchemaTypeGUID = this.createOrUpdateSchemaType(userId, serverName, schemaTypeRequestBody.getSchemaType(), schemaTypeRequestBody.getExternalSourceName());
            response.setGUID(newSchemaTypeGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdateSchemaType", (Object)response.toString());
        return response;
    }

    public GUIDResponse createOrUpdatePortImplementation(String userId, String serverName, PortImplementationRequestBody portImplementationRequestBody) {
        String methodName = "createOrUpdatePortImplementation";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortImplementation");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portImplementationRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdatePortImplementation", serverName);
                return response;
            }
            String portImplementationGUID = this.createOrUpdatePortImplementationWithSchemaType(userId, serverName, portImplementationRequestBody.getPortImplementation(), portImplementationRequestBody.getExternalSourceName());
            response.setGUID(portImplementationGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdatePortImplementation", (Object)response.toString());
        return response;
    }

    public GUIDResponse createOrUpdatePortAlias(String userId, String serverName, PortAliasRequestBody portAliasRequestBody) {
        String methodName = "createOrUpdatePortAliasWithDelegation";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortAliasWithDelegation");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portAliasRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdatePortAliasWithDelegation", serverName);
                return response;
            }
            response.setGUID(this.createOrUpdatePortAliasWithDelegation(userId, serverName, portAliasRequestBody.getPortAlias(), portAliasRequestBody.getExternalSourceName()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdatePortAliasWithDelegation", (Object)response.toString());
        return response;
    }

    public ProcessListResponse createOrUpdateProcesses(String userId, String serverName, ProcessesRequestBody processesRequestBody) {
        String methodName = "createOrUpdateProcesses";
        log.debug("Calling method: {}", (Object)"createOrUpdateProcesses");
        ProcessListResponse response = new ProcessListResponse();
        try {
            if (processesRequestBody == null || CollectionUtils.isEmpty((Collection)processesRequestBody.getProcesses())) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdateProcesses", serverName);
                return response;
            }
            List<GUIDResponse> guidResponses = this.createOrUpdateProcesses(userId, serverName, processesRequestBody.getProcesses(), processesRequestBody.getExternalSourceName());
            Predicate<GUIDResponse> processStatusPredicate = guidResponse -> guidResponse.getRelatedHTTPCode() == HttpStatus.OK.value();
            Map<Boolean, List<GUIDResponse>> mappedResponses = guidResponses.parallelStream().collect(Collectors.partitioningBy(processStatusPredicate));
            List<GUIDResponse> createdProcesses = this.getGuidResponses(response, mappedResponses.get(Boolean.TRUE));
            this.handleFailedProcesses(response, mappedResponses.get(Boolean.FALSE));
            createdProcesses.parallelStream().forEach(guidResponse -> this.updateProcessStatus(userId, serverName, (GUIDResponse)guidResponse, InstanceStatus.ACTIVE));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdateProcesses", (Object)response.toString());
        return response;
    }

    public void handleFailedProcesses(ProcessListResponse response, List<GUIDResponse> failedProcesses) {
        response.setFailedGUIDs(failedProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        failedProcesses.parallelStream().forEach(guidResponse -> this.captureException((FFDCResponseBase)guidResponse, (GUIDListResponse)response));
    }

    public List<GUIDResponse> getGuidResponses(ProcessListResponse response, List<GUIDResponse> createdProcesses) {
        response.setGUIDs(createdProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        return createdProcesses;
    }

    private void captureException(FFDCResponseBase guidResponse, GUIDListResponse response) {
        response.setExceptionErrorMessage(guidResponse.getExceptionErrorMessage());
        response.setExceptionClassName(guidResponse.getExceptionClassName());
        response.setExceptionSystemAction(guidResponse.getExceptionSystemAction());
        response.setExceptionUserAction(guidResponse.getExceptionUserAction());
        response.setRelatedHTTPCode(guidResponse.getRelatedHTTPCode());
        response.setExceptionProperties(guidResponse.getExceptionProperties());
    }

    public void updateProcessStatus(String userId, String serverName, GUIDResponse response, InstanceStatus instanceStatus) {
        String methodName = "updateProcessStatus";
        log.debug("Calling method: {}", (Object)"updateProcessStatus");
        try {
            ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "updateProcessStatus");
            processHandler.updateProcessStatus(userId, response.getGUID(), instanceStatus);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"updateProcessStatus", (Object)response.toString());
    }

    public List<GUIDResponse> createOrUpdateProcesses(String userId, String serverName, List<Process> processes, String externalSourceName) {
        Predicate<Process> hasPortImplementationsPredicate = process -> CollectionUtils.isNotEmpty((Collection)process.getPortImplementations());
        Map<Boolean, List<Process>> partitionedProcesses = processes.parallelStream().collect(Collectors.partitioningBy(hasPortImplementationsPredicate));
        ArrayList<GUIDResponse> guidResponses = new ArrayList<GUIDResponse>();
        Consumer<Process> processConsumer = process -> guidResponses.add(this.createOrUpdateProcess(userId, serverName, (Process)process, externalSourceName));
        partitionedProcesses.get(Boolean.TRUE).parallelStream().forEach(processConsumer);
        partitionedProcesses.get(Boolean.FALSE).forEach(processConsumer);
        return guidResponses;
    }

    public GUIDResponse addPortsToProcess(String userId, String serverName, String processGuid, PortListRequestBody portListRequestBody) {
        String methodName = "addPortsToProcess";
        log.debug("Calling method: {}", (Object)"addPortsToProcess");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portListRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addPortsToProcess", serverName);
                return response;
            }
            ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addPortsToProcess");
            for (String portGUID : portListRequestBody.getPorts()) {
                processHandler.addProcessPortRelationship(userId, processGuid, portGUID, portListRequestBody.getExternalSourceName());
            }
            response.setGUID(processGuid);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"addPortsToProcess", (Object)response.toString());
        return response;
    }

    public VoidResponse addLineageMappings(String userId, String serverName, LineageMappingsRequestBody lineageMappingsRequestBody) {
        String methodName = "addLineageMappings";
        log.debug("Calling method: {}", (Object)"addLineageMappings");
        VoidResponse response = new VoidResponse();
        try {
            if (lineageMappingsRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLineageMappings", serverName);
                return response;
            }
            this.addLineageMappings(userId, serverName, lineageMappingsRequestBody.getLineageMappings(), (FFDCResponseBase)response, lineageMappingsRequestBody.getExternalSourceName());
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"addLineageMappings", (Object)response.toString());
        return response;
    }

    public GUIDResponse createOrUpdateProcess(String userId, String serverName, Process process, String externalSourceName) {
        String methodName = "createOrUpdateProcess";
        log.debug("Calling method: {}", (Object)"createOrUpdateProcess");
        String qualifiedName = process.getQualifiedName();
        String processName = process.getName();
        String description = process.getDescription();
        String latestChange = process.getLatestChange();
        List zoneMembership = process.getZoneMembership();
        String displayName = process.getDisplayName();
        String formula = process.getFormula();
        String owner = process.getOwner();
        OwnerType ownerType = process.getOwnerType();
        List portImplementations = process.getPortImplementations();
        List portAliases = process.getPortAliases();
        List lineageMappings = process.getLineageMappings();
        UpdateSemantic updateSemantic = process.getUpdateSemantic();
        GUIDResponse response = new GUIDResponse();
        try {
            Set<String> portImplementationGUIDs = this.createOrUpdatePortImplementations(userId, serverName, portImplementations, response, externalSourceName);
            Set<String> portAliasGUIDs = this.createOrUpdatePortAliases(userId, serverName, portAliases, response, externalSourceName);
            if (response.getRelatedHTTPCode() != HttpStatus.OK.value()) {
                return response;
            }
            ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "createOrUpdateProcess");
            String processGUID = processHandler.findProcess(userId, qualifiedName);
            if (StringUtils.isEmpty((Object)processGUID)) {
                processGUID = processHandler.createProcess(userId, qualifiedName, processName, description, latestChange, zoneMembership, displayName, formula, owner, ownerType, externalSourceName);
            } else {
                processHandler.updateProcess(userId, processGUID, qualifiedName, processName, description, latestChange, zoneMembership, displayName, formula, owner, ownerType);
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.DRAFT);
                if (updateSemantic == UpdateSemantic.REPLACE) {
                    this.deleteObsoletePorts(userId, serverName, portImplementationGUIDs, processGUID, "PortImplementation", response);
                    this.deleteObsoletePorts(userId, serverName, portAliasGUIDs, processGUID, "PortAlias", response);
                }
            }
            this.addProcessPortRelationships(userId, serverName, processGUID, Stream.concat(portImplementationGUIDs.stream(), portAliasGUIDs.stream()).collect(Collectors.toSet()), response, externalSourceName);
            this.addLineageMappings(userId, serverName, lineageMappings, (FFDCResponseBase)response, externalSourceName);
            response.setGUID(processGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdateProcess", (Object)response.toString());
        return response;
    }

    private void addProcessPortRelationships(String userId, String serverName, String processGUID, Set<String> portGUIDs, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessPortRelationships";
        ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessPortRelationships");
        portGUIDs.parallelStream().forEach(portGUID -> {
            try {
                processHandler.addProcessPortRelationship(userId, processGUID, (String)portGUID, externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
            }
        });
    }

    private void deleteObsoletePorts(String userId, String serverName, Set<String> newPortGUIDs, String processGUID, String portTypeName, GUIDResponse response) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteObsoletePorts";
        log.debug("Calling method: {}", (Object)"deleteObsoletePorts");
        if (CollectionUtils.isEmpty(newPortGUIDs)) {
            return;
        }
        ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteObsoletePorts");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "deleteObsoletePorts");
        Set<String> oldPortGUIDs = processHandler.getPortsForProcess(userId, processGUID);
        List<String> obsoletePorts = oldPortGUIDs.parallelStream().collect(Collectors.partitioningBy(newPortGUIDs::contains)).get(Boolean.FALSE);
        obsoletePorts.parallelStream().forEach(portGUID -> {
            try {
                portHandler.removePort(userId, (String)portGUID, portTypeName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
            }
        });
        log.debug("Returning from method: {} with void response", (Object)"deleteObsoletePorts");
    }

    private Set<String> createOrUpdatePortImplementations(String userId, String serverName, List<PortImplementation> portImplementations, GUIDResponse response, String externalSourceName) {
        String methodName = "createOrUpdatePortImplementations";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortImplementations");
        HashSet<String> portImplementationGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portImplementations)) {
            portImplementations.parallelStream().forEach(portImplementation -> {
                try {
                    portImplementationGUIDs.add(this.createOrUpdatePortImplementationWithSchemaType(userId, serverName, (PortImplementation)portImplementation, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
                }
            });
        }
        return portImplementationGUIDs;
    }

    private Set<String> createOrUpdatePortAliases(String userId, String serverName, List<PortAlias> portAliases, GUIDResponse response, String externalSourceName) {
        String methodName = "createOrUpdatePortAliases";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortAliases");
        HashSet<String> portAliasGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portAliases)) {
            portAliases.parallelStream().forEach(portAlias -> {
                try {
                    portAliasGUIDs.add(this.createOrUpdatePortAliasWithDelegation(userId, serverName, (PortAlias)portAlias, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
                }
            });
        }
        return portAliasGUIDs;
    }

    private void addLineageMappings(String userId, String serverName, List<LineageMapping> lineageMappings, FFDCResponseBase response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLineageMappings";
        log.debug("Calling method: {}", (Object)"addLineageMappings");
        if (CollectionUtils.isEmpty(lineageMappings)) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addLineageMappings");
        lineageMappings.parallelStream().forEach(lineageMapping -> {
            try {
                dataEngineSchemaTypeHandler.addLineageMappingRelationship(userId, lineageMapping.getSourceAttribute(), lineageMapping.getTargetAttribute(), externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException(response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException(response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException(response, error);
            }
        });
    }

    private String createOrUpdateSchemaType(String userId, String serverName, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdateSchemaType";
        log.debug("Calling method: {}", (Object)"createOrUpdateSchemaType");
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "createOrUpdateSchemaType");
        String schemaTypeGUID = dataEngineSchemaTypeHandler.createOrUpdateSchemaType(userId, schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getAuthor(), schemaType.getEncodingStandard(), schemaType.getUsage(), schemaType.getVersionNumber(), schemaType.getAttributeList(), externalSourceName);
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdateSchemaType", (Object)schemaTypeGUID);
        return schemaTypeGUID;
    }

    public String createOrUpdatePortImplementationWithSchemaType(String userId, String serverName, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdatePortImplementationWithSchemaType";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortImplementationWithSchemaType");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "createOrUpdatePortImplementationWithSchemaType");
        String schemaTypeGUID = this.createOrUpdateSchemaType(userId, serverName, portImplementation.getSchemaType(), externalSourceName);
        String portImplementationGUID = portHandler.findPortImplementation(userId, portImplementation.getQualifiedName());
        if (StringUtils.isEmpty((Object)portImplementationGUID)) {
            portImplementationGUID = portHandler.createPortImplementation(userId, portImplementation.getQualifiedName(), portImplementation.getDisplayName(), portImplementation.getPortType(), externalSourceName);
        } else {
            portHandler.updatePortImplementation(userId, portImplementationGUID, portImplementation.getQualifiedName(), portImplementation.getDisplayName(), portImplementation.getPortType());
            if (portImplementation.getUpdateSemantic() == UpdateSemantic.REPLACE) {
                this.deleteObsoleteSchemaType(userId, serverName, schemaTypeGUID, portHandler.getSchemaTypeForPort(userId, portImplementationGUID));
            }
        }
        portHandler.addPortSchemaRelationship(userId, portImplementationGUID, schemaTypeGUID, externalSourceName);
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdatePortImplementationWithSchemaType", (Object)portImplementationGUID);
        return portImplementationGUID;
    }

    private void deleteObsoleteSchemaType(String userId, String serverName, String schemaTypeGUID, String oldSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteObsoleteSchemaType";
        log.debug("Calling method: {}", (Object)"deleteObsoleteSchemaType");
        if (!oldSchemaTypeGUID.equalsIgnoreCase(schemaTypeGUID)) {
            DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteObsoleteSchemaType");
            dataEngineSchemaTypeHandler.removeSchemaType(userId, oldSchemaTypeGUID);
        }
        log.debug("Returning from method: {} with void response: {}", (Object)"deleteObsoleteSchemaType");
    }

    public String createOrUpdatePortAliasWithDelegation(String userId, String serverName, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdatePortAliasWithDelegation";
        log.debug("Calling method: {}", (Object)"createOrUpdatePortAliasWithDelegation");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "createOrUpdatePortAliasWithDelegation");
        String portAliasGUID = portHandler.findPortAlias(userId, portAlias.getQualifiedName());
        if (StringUtils.isEmpty((Object)portAliasGUID)) {
            portAliasGUID = portHandler.createPortAlias(userId, portAlias.getQualifiedName(), portAlias.getDisplayName(), portAlias.getPortType(), externalSourceName);
        } else {
            portHandler.updatePortAlias(userId, portAliasGUID, portAlias.getQualifiedName(), portAlias.getDisplayName(), portAlias.getPortType());
        }
        if (!StringUtils.isEmpty((Object)portAlias.getDelegatesTo())) {
            portHandler.addPortDelegationRelationship(userId, portAliasGUID, portAlias.getPortType(), portAlias.getDelegatesTo(), externalSourceName);
        }
        log.debug("Returning from method: {} with response: {}", (Object)"createOrUpdatePortAliasWithDelegation", (Object)portAliasGUID);
        return portAliasGUID;
    }
}

