/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ExternalDataEnginePropertiesBuilder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineRegistrationHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;

    public DataEngineRegistrationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
    }

    public String createExternalDataEngine(String userId, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalDataEngine";
        this.invalidParameterHandler.validateUserId(userId, "createExternalDataEngine");
        this.invalidParameterHandler.validateName(softwareServerCapability.getQualifiedName(), "qualifiedName", "createExternalDataEngine");
        ExternalDataEnginePropertiesBuilder builder = new ExternalDataEnginePropertiesBuilder(softwareServerCapability.getQualifiedName(), softwareServerCapability.getDisplayName(), softwareServerCapability.getDescription(), softwareServerCapability.getEngineType(), softwareServerCapability.getEngineVersion(), softwareServerCapability.getPatchLevel(), softwareServerCapability.getSource(), null, null, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("createExternalDataEngine");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "SoftwareServerCapability");
        return this.repositoryHandler.createEntity(userId, entityTypeDef.getGUID(), entityTypeDef.getName(), properties, "createExternalDataEngine");
    }

    public String getExternalDataEngineByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalDataEngineByQualifiedName";
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        this.invalidParameterHandler.validateUserId(userId, "getExternalDataEngineByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalDataEngineByQualifiedName");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "getExternalDataEngineByQualifiedName");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "SoftwareServerCapability");
        EntityDetail retrievedEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "getExternalDataEngineByQualifiedName");
        if (retrievedEntity == null) {
            return null;
        }
        return retrievedEntity.getGUID();
    }
}

