/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineSchemaTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(DataEngineSchemaTypeHandler.class);
    private final String serviceName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaTypeHandler schemaTypeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;

    public DataEngineSchemaTypeHandler(String serviceName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, SchemaTypeHandler schemaTypeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler) {
        this.serviceName = serviceName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
    }

    public String createOrUpdateSchemaType(String userId, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateSchemaType";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getQualifiedName(), "qualifiedName", "createOrUpdateSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getDisplayName(), "displayName", "createOrUpdateSchemaType");
        org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType newSchemaType = this.createTabularSchemaType(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getAuthor(), schemaType.getEncodingStandard(), schemaType.getUsage(), schemaType.getVersionNumber());
        List<SchemaAttribute> newSchemaAttributes = this.createTabularColumns(schemaType.getAttributeList());
        String schemaTypeGUID = this.schemaTypeHandler.saveExternalSchemaType(userId, newSchemaType, newSchemaAttributes, externalSourceGUID, externalSourceName, "createOrUpdateSchemaType");
        this.addTypeEmbeddedAttributeClassification(userId, schemaType.getAttributeList());
        return schemaTypeGUID;
    }

    public void addLineageMappingRelationship(String userId, String sourceSchemaAttributeQualifiedName, String targetSchemaAttributeQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addLineageMappingRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(sourceSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(targetSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        String sourceSchemaAttributeGUID = this.findSchemaAttribute(userId, sourceSchemaAttributeQualifiedName);
        String targetSchemaAttributeGUID = this.findSchemaAttribute(userId, targetSchemaAttributeQualifiedName);
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "LineageMapping");
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, sourceSchemaAttributeGUID, "SchemaAttribute", targetSchemaAttributeGUID, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "addLineageMappingRelationship");
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        if (relationship == null) {
            this.repositoryHandler.createExternalRelationship(userId, relationshipTypeDef.getGUID(), externalSourceGUID, externalSourceName, sourceSchemaAttributeGUID, targetSchemaAttributeGUID, null, "addLineageMappingRelationship");
        }
    }

    public void removeSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "removeSchemaType");
        Set<String> oldSchemaAttributeGUIDs = this.getSchemaAttributesForSchemaType(userId, schemaTypeGUID);
        for (String oldSchemaAttributeGUID : oldSchemaAttributeGUIDs) {
            this.removeTabularColumn(userId, oldSchemaAttributeGUID);
        }
        this.removeTabularSchemaType(userId, schemaTypeGUID);
    }

    private void addTypeEmbeddedAttributeClassification(String userId, List<Attribute> newAttributes) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "addTypeEmbeddedAttributeClassifications";
        for (Attribute newAttribute : newAttributes) {
            String schemaAttributeGUID = this.findSchemaAttribute(userId, newAttribute.getQualifiedName());
            TypeDef classificationTypeDef = this.repositoryHelper.getTypeDefByName(userId, "TypeEmbeddedAttribute");
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "dataType", newAttribute.getDataType(), "addTypeEmbeddedAttributeClassifications");
            this.repositoryHandler.classifyEntity(userId, schemaAttributeGUID, classificationTypeDef.getGUID(), classificationTypeDef.getName(), properties, "addTypeEmbeddedAttributeClassifications");
        }
    }

    private String findSchemaAttribute(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException {
        TypeDef entityTypeDef;
        InstanceProperties properties;
        String methodName = "findSchemaAttribute";
        EntityDetail retrievedEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName), "qualifiedName", properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "findSchemaAttribute"), (entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "SchemaAttribute")).getGUID(), entityTypeDef.getName(), "findSchemaAttribute");
        if (retrievedEntity == null) {
            log.debug("Searching for entity with qualifiedName: {}. Result is null", (Object)qualifiedName);
            return null;
        }
        log.debug("Searching for entity with qualifiedName: {}. Result is {}", (Object)qualifiedName, (Object)retrievedEntity.getGUID());
        return retrievedEntity.getGUID();
    }

    private Set<String> getSchemaAttributesForSchemaType(String userId, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getSchemaAttributesForSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesForSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "getSchemaAttributesForSchemaType");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "AttributeForSchema");
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaTypeGUID, "SchemaType", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getSchemaAttributesForSchemaType");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private void removeTabularColumn(String userId, String tabularColumnGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTabularColumn";
        this.invalidParameterHandler.validateUserId(userId, "removeTabularColumn");
        this.invalidParameterHandler.validateGUID(tabularColumnGUID, "guid", "removeTabularColumn");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "TabularColumn");
        this.repositoryHandler.removeEntity(userId, tabularColumnGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), null, null, "removeTabularColumn");
    }

    private List<SchemaAttribute> createTabularColumns(List<Attribute> attributeList) throws InvalidParameterException {
        String methodName = "createTabularColumns";
        ArrayList<SchemaAttribute> schemaAttributes = new ArrayList<SchemaAttribute>();
        for (Attribute attribute : attributeList) {
            SchemaAttribute schemaAttribute = this.schemaTypeHandler.getEmptyTabularColumn();
            String qualifiedName = attribute.getQualifiedName();
            String displayName = attribute.getDisplayName();
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createTabularColumns");
            this.invalidParameterHandler.validateName(displayName, "displayName", "createTabularColumns");
            schemaAttribute.setQualifiedName(qualifiedName);
            schemaAttribute.setAttributeName(displayName);
            schemaAttribute.setDefaultValueOverride(attribute.getDefaultValueOverride());
            schemaAttribute.setElementPosition(attribute.getPosition());
            Map<String, String> attributeProperties = this.buildSchemaAttributeProperties(attribute);
            schemaAttribute.setAdditionalProperties(attributeProperties);
            schemaAttributes.add(schemaAttribute);
        }
        return schemaAttributes;
    }

    private Map<String, String> buildSchemaAttributeProperties(Attribute attribute) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (attribute.getMaxCardinality() != null) {
            additionalProperties.put("maxCardinality", attribute.getMaxCardinality());
        }
        if (attribute.getMinCardinality() != null) {
            additionalProperties.put("minCardinality", attribute.getMinCardinality());
        }
        if (attribute.getAllowsDuplicateValues() != null) {
            additionalProperties.put("allowsDuplicateValues", attribute.getAllowsDuplicateValues());
        }
        if (attribute.getOrderedValues() != null) {
            additionalProperties.put("orderedValues", attribute.getOrderedValues());
        }
        return additionalProperties;
    }

    private org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType createTabularSchemaType(String qualifiedName, String displayName, String author, String encodingStandard, String usage, String versionNumber) {
        ComplexSchemaType schemaType = this.schemaTypeHandler.getEmptyComplexSchemaType("248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType");
        schemaType.setQualifiedName(qualifiedName);
        schemaType.setDisplayName(displayName);
        schemaType.setAuthor(author);
        schemaType.setEncodingStandard(encodingStandard);
        schemaType.setUsage(usage);
        schemaType.setVersionNumber(versionNumber);
        return schemaType;
    }

    private void removeTabularSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTabularSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "removeTabularSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "removeTabularSchemaType");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "TabularSchemaType");
        this.repositoryHandler.removeEntity(userId, schemaTypeGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), null, null, "removeTabularSchemaType");
    }
}

