/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ProcessPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.springframework.util.StringUtils;

public class ProcessHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final AssetHandler assetHandler;
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    private List<String> supportedZones;
    private List<String> defaultZones;

    public ProcessHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataEngineRegistrationHandler dataEngineRegistrationHandler, AssetHandler assetHandler, List<String> defaultZones, List<String> supportedZones) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.assetHandler = assetHandler;
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        this.securityVerifier = securityVerifier;
    }

    public String createProcess(String userId, Process process, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        this.setAssetType(process, "createProcess");
        List zoneMembership = this.securityVerifier.initializeAssetZones(this.defaultZones, (Asset)process);
        process.setZoneMembership(zoneMembership);
        this.securityVerifier.validateUserForAssetCreate(userId, (Asset)process);
        this.validateProcessParameters(userId, process.getQualifiedName(), "createProcess");
        ProcessPropertiesBuilder builder = new ProcessPropertiesBuilder(process.getQualifiedName(), process.getName(), process.getDisplayName(), process.getDescription(), process.getOwner(), process.getOwnerType(), zoneMembership, process.getLatestChange(), process.getFormula(), null, null, this.repositoryHelper, this.serverName, this.serviceName);
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Process");
        String processGUID = this.repositoryHandler.createExternalEntity(userId, entityTypeDef.getGUID(), entityTypeDef.getName(), externalSourceGUID, externalSourceName, builder.getInstanceProperties("createProcess"), InstanceStatus.DRAFT, "createProcess");
        this.addAssetClassifications(userId, process, builder, processGUID);
        return processGUID;
    }

    public void updateProcess(String userId, String processGUID, Process updatedProcess) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        EntityDetail processEntity = this.repositoryHandler.getEntityByGUID(userId, processGUID, "guid", "Process", "updateProcess");
        ProcessConverter processConverter = new ProcessConverter(processEntity, null, this.repositoryHelper, "updateProcess");
        Process originalProcess = processConverter.getProcessBean();
        if (originalProcess != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(processGUID, "guid", originalProcess.getZoneMembership(), this.supportedZones, this.serviceName, "updateProcess");
            this.setAssetType(updatedProcess, "updateProcess");
            this.assetHandler.updateAsset(userId, (Asset)originalProcess, processConverter.getAssetAuditHeader(), (Asset)updatedProcess, null, null, null, "updateProcess");
        }
    }

    public String findProcess(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "findProcess";
        this.validateProcessParameters(userId, qualifiedName, "findProcess");
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "findProcess");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Process");
        EntityDetail retrievedEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "findProcess");
        if (retrievedEntity == null) {
            return null;
        }
        return retrievedEntity.getGUID();
    }

    public void addProcessPortRelationship(String userId, String processGUID, String portGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addProcessPortRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addProcessPortRelationship");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "addProcessPortRelationship");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "addProcessPortRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "ProcessPort");
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, processGUID, "Process", portGUID, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "addProcessPortRelationship");
        if (relationship == null) {
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            this.repositoryHandler.createExternalRelationship(userId, relationshipTypeDef.getGUID(), externalSourceGUID, externalSourceName, processGUID, portGUID, null, "addProcessPortRelationship");
        }
    }

    public void updateProcessStatus(String userId, String guid, InstanceStatus instanceStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessStatus");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateProcessStatus");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Process");
        this.repositoryHandler.updateEntityStatus(userId, guid, entityTypeDef.getGUID(), entityTypeDef.getName(), instanceStatus, "updateProcessStatus");
    }

    public Set<String> getPortsForProcess(String userId, String processGUID, String portTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsForProcess";
        this.invalidParameterHandler.validateUserId(userId, "getPortsForProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "getPortsForProcess");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "ProcessPort");
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, processGUID, "Process", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getPortsForProcess");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().filter(entityDetail -> entityDetail.getType().getTypeDefName().equalsIgnoreCase(portTypeName)).map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private void validateProcessParameters(String userId, String qualifiedName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }

    private void addAssetClassifications(String userId, Process process, ProcessPropertiesBuilder builder, String processGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "addAssetClassifications";
        if (!CollectionUtils.isEmpty((Collection)process.getZoneMembership())) {
            this.repositoryHandler.classifyEntity(userId, processGUID, "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", builder.getZoneMembershipProperties("addAssetClassifications"), "addAssetClassifications");
        }
        if (!StringUtils.isEmpty((Object)process.getOwner())) {
            this.repositoryHandler.classifyEntity(userId, processGUID, "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", builder.getOwnerProperties("addAssetClassifications"), "addAssetClassifications");
        }
    }

    private void setAssetType(Process process, String methodName) throws InvalidParameterException {
        ElementType elementType = new ElementType();
        String assetTypeGUID = this.invalidParameterHandler.validateTypeName("Process", "Asset", this.serviceName, methodName, this.repositoryHelper);
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId(assetTypeGUID);
        elementType.setElementTypeName("Process");
        process.setType(elementType);
    }
}

