/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.PortType;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.PortPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PortHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;

    public PortHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataEngineRegistrationHandler dataEngineRegistrationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
    }

    public String createPortImplementation(String userId, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, portImplementation.getQualifiedName(), portImplementation.getDisplayName(), portImplementation.getPortType(), "PortImplementation", externalSourceName);
    }

    public String createPortAlias(String userId, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, portAlias.getQualifiedName(), portAlias.getDisplayName(), portAlias.getPortType(), "PortAlias", externalSourceName);
    }

    public void updatePortImplementation(String userId, String portGUID, PortImplementation portImplementation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, portGUID, portImplementation.getQualifiedName(), portImplementation.getDisplayName(), portImplementation.getPortType(), "PortImplementation");
    }

    public void updatePortAlias(String userId, String portGUID, PortAlias portAlias) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, portGUID, portAlias.getQualifiedName(), portAlias.getDisplayName(), portAlias.getPortType(), "PortAlias");
    }

    private String createPort(String userId, String qualifiedName, String displayName, PortType portType, String entityTpeName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        InstanceProperties properties = this.buildPortInstanceProperties(userId, qualifiedName, displayName, portType, "createPort");
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTpeName);
        return this.repositoryHandler.createExternalEntity(userId, entityTypeDef.getGUID(), entityTypeDef.getName(), externalSourceGUID, externalSourceName, properties, "createPort");
    }

    private void updatePort(String userId, String portGUID, String qualifiedName, String displayName, PortType portType, String entityTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        InstanceProperties properties = this.buildPortInstanceProperties(userId, qualifiedName, displayName, portType, "updatePort");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        this.repositoryHandler.updateEntity(userId, portGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), properties, "updatePort");
    }

    public void addPortSchemaRelationship(String userId, String portGUID, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortSchemaRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "addPortSchemaRelationship");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "addPortSchemaRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "PortSchema");
        this.createRelationship(userId, portGUID, schemaTypeGUID, "Port", relationshipTypeDef, "addPortSchemaRelationship", externalSourceName);
    }

    public String findSchemaTypeForPort(String userId, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaTypeForPort";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaTypeForPort");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "findSchemaTypeForPort");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "PortSchema");
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, portGUID, "Port", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "findSchemaTypeForPort");
        if (entity == null) {
            return null;
        }
        return entity.getGUID();
    }

    public void addPortDelegationRelationship(String userId, String portGUID, PortType portType, String delegatesTo, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortDelegationRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortDelegationRelationship");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "addPortDelegationRelationship");
        this.invalidParameterHandler.validateName(delegatesTo, "qualifiedName", "addPortDelegationRelationship");
        EntityDetail delegatedPort = this.getPortEntityDetailByQualifiedName(userId, delegatesTo);
        String delegatedPortType = this.getPortType(delegatedPort);
        if (portType.getName().equalsIgnoreCase(delegatedPortType)) {
            TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "PortDelegation");
            this.createRelationship(userId, portGUID, delegatedPort.getGUID(), "Port", relationshipTypeDef, "addPortDelegationRelationship", externalSourceName);
        } else {
            this.throwInvalidParameterException(portGUID, "addPortDelegationRelationship", delegatedPort, delegatedPortType);
        }
    }

    public void removePort(String userId, String portGUID, String entityTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removePort";
        this.invalidParameterHandler.validateUserId(userId, "removePort");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "removePort");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        this.repositoryHandler.removeEntity(userId, portGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), null, null, "removePort");
    }

    public String findPortImplementation(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findPort(userId, qualifiedName, "PortImplementation");
    }

    public String findPortAlias(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findPort(userId, qualifiedName, "PortAlias");
    }

    private String findPort(String userId, String qualifiedName, String entityTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findPort";
        this.invalidParameterHandler.validateUserId(userId, "findPort");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "findPort");
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "findPort");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        EntityDetail retrievedEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "findPort");
        if (retrievedEntity == null) {
            return null;
        }
        return retrievedEntity.getGUID();
    }

    private EntityDetail getPortEntityDetailByQualifiedName(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortEntityDetailByQualifiedName";
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        this.invalidParameterHandler.validateUserId(userId, "getPortEntityDetailByQualifiedName");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getPortEntityDetailByQualifiedName");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "getPortEntityDetailByQualifiedName");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Port");
        return this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "getPortEntityDetailByQualifiedName");
    }

    private String getPortType(EntityDetail delegatedPort) {
        if (delegatedPort == null) {
            return null;
        }
        InstanceProperties instanceProperties = delegatedPort.getProperties();
        if (instanceProperties == null) {
            return null;
        }
        EnumPropertyValue portTypeValue = (EnumPropertyValue)delegatedPort.getProperties().getPropertyValue("portType");
        if (portTypeValue == null) {
            return null;
        }
        return portTypeValue.getSymbolicName();
    }

    private void createRelationship(String userId, String firstGUID, String secondGUID, String firstEntityTypeName, TypeDef relationshipTypeDef, String methodName, String externalSourceName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, firstGUID, firstEntityTypeName, secondGUID, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), methodName);
        if (relationship == null) {
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            this.repositoryHandler.createExternalRelationship(userId, relationshipTypeDef.getGUID(), externalSourceGUID, externalSourceName, firstGUID, secondGUID, null, methodName);
        }
    }

    private InstanceProperties buildPortInstanceProperties(String userId, String qualifiedName, String displayName, PortType portType, String methodName) throws InvalidParameterException {
        this.validatePortParameters(userId, qualifiedName, displayName, methodName);
        PortPropertiesBuilder builder = new PortPropertiesBuilder(qualifiedName, displayName, portType, this.repositoryHelper, this.serviceName, this.serverName);
        return builder.getInstanceProperties(methodName);
    }

    private void validatePortParameters(String userId, String qualifiedName, String displayName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }

    private void throwInvalidParameterException(String portGUID, String methodName, EntityDetail delegatedPort, String delegatedPortType) throws InvalidParameterException {
        DataEngineErrorCode errorCode = DataEngineErrorCode.INVALID_PORT_TYPE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{delegatedPort.getGUID(), portGUID});
        throw new InvalidParameterException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), delegatedPortType);
    }
}

