/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.auditlog.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.server.listeners.DataEngineInTopicListener;
import org.odpi.openmetadata.accessservices.dataengine.server.processors.DataEngineEventProcessor;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineAdmin
extends AccessServiceAdmin {
    private OMRSAuditLog auditLog;
    private DataEngineServicesInstance instance;
    private String serverName;
    private static final Logger log = LoggerFactory.getLogger(DataEngineAdmin.class);

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        DataEngineAuditCode auditCode = DataEngineAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataEngineServicesInstance(repositoryConnector, supportedZones, defaultZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceInTopic() != null) {
                DataEngineEventProcessor dataEngineEventProcessor = new DataEngineEventProcessor(this.instance, auditLog);
                DataEngineInTopicListener dataEngineInTopicListener = new DataEngineInTopicListener(auditLog, dataEngineEventProcessor);
                OpenMetadataTopicConnector dataEngineInTopicConnector = this.initializeDataEngineTopicConnector(accessServiceConfig.getAccessServiceInTopic());
                if (dataEngineInTopicConnector != null) {
                    dataEngineInTopicConnector.registerListener((OpenMetadataTopicListener)dataEngineInTopicListener);
                    dataEngineInTopicConnector.start();
                }
            }
            auditCode = DataEngineAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException e) {
            throw e;
        }
        catch (Exception error) {
            auditCode = DataEngineAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            DataEngineAuditCode auditCode = DataEngineAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            OMAGConfigurationErrorException e = new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
            log.error("Exception in returning the topic connector for Data Engine: {}", (Throwable)e);
            throw e;
        }
    }

    private OpenMetadataTopicConnector initializeDataEngineTopicConnector(Connection topicConnection) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        if (topicConnection != null) {
            try {
                return this.getTopicConnector(topicConnection);
            }
            catch (Exception e) {
                DataEngineAuditCode auditCode = DataEngineAuditCode.ERROR_INITIALIZING_TOPIC_CONNECTION;
                this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicConnection.toString(), this.serverName, e.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
                throw e;
            }
        }
        return null;
    }
}

