/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.PortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.ProcessHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineServicesInstance
extends OCFOMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.DATA_ENGINE_OMAS;
    private ProcessHandler processHandler;
    private DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private PortHandler portHandler;

    DataEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        super(description.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, auditLog, localServerUserId, maxPageSize);
        if (this.repositoryHandler != null) {
            this.dataEngineRegistrationHandler = new DataEngineRegistrationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
            this.processHandler = new ProcessHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataEngineRegistrationHandler, this.assetHandler, defaultZones, supportedZones);
            this.dataEngineSchemaTypeHandler = new DataEngineSchemaTypeHandler(this.serviceName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.schemaTypeHandler, this.dataEngineRegistrationHandler);
            this.portHandler = new PortHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataEngineRegistrationHandler);
            if (this.securityVerifier != null) {
                this.processHandler.setSecurityVerifier(this.securityVerifier);
            }
        } else {
            String methodName = "new ServiceInstance";
            DataEngineErrorCode errorCode = DataEngineErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"new ServiceInstance"});
            throw new NewInstanceException(errorCode.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    DataEngineRegistrationHandler getDataEngineRegistrationHandler() {
        return this.dataEngineRegistrationHandler;
    }

    DataEngineSchemaTypeHandler getDataEngineSchemaTypeHandler() {
        return this.dataEngineSchemaTypeHandler;
    }

    PortHandler getPortHandler() {
        return this.portHandler;
    }
}

