/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessToPortListEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessesEvent;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineException;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DataEngineEventProcessor {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(DataEngineEventProcessor.class);
    private static final String DEBUG_MESSAGE_METHOD = "Calling method: {}";
    private final OMRSAuditLog auditLog;
    private final String serverName;
    private DataEngineRESTServices dataEngineRESTServices = new DataEngineRESTServices();

    public DataEngineEventProcessor(DataEngineServicesInstance instance, OMRSAuditLog auditLog) throws NewInstanceException {
        this.auditLog = auditLog;
        this.serverName = instance.getServerName();
    }

    public void processDataEngineRegistrationEvent(String dataEngineEvent) {
        String methodName = "processDataEngineRegistrationEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processDataEngineRegistrationEvent");
        try {
            DataEngineRegistrationEvent dataEngineRegistrationEvent = (DataEngineRegistrationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DataEngineRegistrationEvent.class);
            this.dataEngineRESTServices.createExternalDataEngine(dataEngineRegistrationEvent.getUserId(), this.serverName, dataEngineRegistrationEvent.getSoftwareServerCapability());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processDataEngineRegistrationEvent", (Exception)e);
        }
    }

    public void processPortAliasEvent(String dataEngineEvent) {
        String methodName = "processPortAliasEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processPortAliasEvent");
        try {
            PortAliasEvent portAliasEvent = (PortAliasEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortAliasEvent.class);
            this.dataEngineRESTServices.createOrUpdatePortAliasWithDelegation(portAliasEvent.getUserId(), this.serverName, portAliasEvent.getPort(), portAliasEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processPortAliasEvent", (Exception)e);
        }
    }

    public void processPortImplementationEvent(String dataEngineEvent) {
        String methodName = "processPortImplementationEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processPortImplementationEvent");
        try {
            PortImplementationEvent portImplementationEvent = (PortImplementationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortImplementationEvent.class);
            this.dataEngineRESTServices.createOrUpdatePortImplementationWithSchemaType(portImplementationEvent.getUserId(), this.serverName, portImplementationEvent.getPortImplementation(), portImplementationEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processPortImplementationEvent", (Exception)e);
        }
    }

    public void processProcessToPortListEvent(String dataEngineEvent) {
        String methodName = "processProcessToPortListEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processProcessToPortListEvent");
        try {
            ProcessToPortListEvent processToPortListEvent = (ProcessToPortListEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessToPortListEvent.class);
            this.dataEngineRESTServices.addPortsToProcess(processToPortListEvent.getUserId(), this.serverName, processToPortListEvent.getProcessGUID(), processToPortListEvent.getPorts(), processToPortListEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processProcessToPortListEvent", (Exception)e);
        }
    }

    public void processLineageMappingsEvent(String dataEngineEvent) {
        String methodName = "processLineageMappingsEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processLineageMappingsEvent");
        try {
            LineageMappingsEvent lineageMappingsEvent = (LineageMappingsEvent)OBJECT_MAPPER.readValue(dataEngineEvent, LineageMappingsEvent.class);
            if (CollectionUtils.isEmpty((Collection)lineageMappingsEvent.getLineageMappings())) {
                return;
            }
            FFDCResponseBase response = new FFDCResponseBase();
            this.dataEngineRESTServices.addLineageMappings(lineageMappingsEvent.getUserId(), this.serverName, lineageMappingsEvent.getLineageMappings(), response, lineageMappingsEvent.getExternalSourceName());
            this.validateResponse(response, dataEngineEvent, "processLineageMappingsEvent");
        }
        catch (JsonProcessingException | DataEngineException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processLineageMappingsEvent", (Exception)e);
        }
    }

    public void processProcessesEvent(String dataEngineEvent) {
        String methodName = "processProcessesEvent";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"processProcessesEvent");
        try {
            ProcessesEvent processesEvent = (ProcessesEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessesEvent.class);
            ProcessListResponse response = this.dataEngineRESTServices.createOrUpdateProcesses(processesEvent.getUserId(), this.serverName, processesEvent.getProcesses(), processesEvent.getExternalSourceName());
            this.validateResponse((FFDCResponseBase)response, dataEngineEvent, "processProcessesEvent");
        }
        catch (JsonProcessingException | DataEngineException e) {
            log.debug("Exception in parsing event from in Data Engine In Topic", e);
            this.logException(dataEngineEvent, "processProcessesEvent", (Exception)e);
        }
    }

    private void logException(String dataEngineEvent, String methodName, Exception e) {
        log.debug("Exception in processing {} from in Data Engine In Topic: {}", (Object)methodName, (Object)e);
        DataEngineErrorCode errorCode = DataEngineErrorCode.PARSE_EVENT_EXCEPTION;
        this.auditLog.logException(methodName, errorCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedErrorMessage(new String[]{dataEngineEvent, e.getMessage()}), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
    }

    private void validateResponse(FFDCResponseBase response, String dataEngineEvent, String methodName) throws DataEngineException {
        if (response.getRelatedHTTPCode() != HttpStatus.OK.value()) {
            DataEngineErrorCode errorCode = DataEngineErrorCode.DATA_ENGINE_EXCEPTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{dataEngineEvent});
            throw new DataEngineException(errorCode.getHttpErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), dataEngineEvent);
        }
    }
}

