/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.PortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.ProcessHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DataEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRESTServices.class);
    private static final String DEBUG_MESSAGE_METHOD = "Calling method: {}";
    private static final String DEBUG_MESSAGE_METHOD_RETURN = "Returning from method: {} with response: {}";
    private static final String DEBUG_METHOD_RETURN_VOID_RESPONSE = "Returning from method: {} with void response";
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createExternalDataEngine(String serverName, String userId, DataEngineRegistrationRequestBody requestBody) {
        String methodName = "createExternalDataEngine";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createExternalDataEngine");
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataEngine", serverName);
                return response;
            }
            response.setGUID(this.createExternalDataEngine(userId, serverName, requestBody.getSoftwareServerCapability()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createExternalDataEngine", (Object)response);
        return response;
    }

    public GUIDResponse getExternalDataEngineByQualifiedName(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataEngineByQualifiedName";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"getExternalDataEngineByQualifiedName");
        GUIDResponse response = new GUIDResponse();
        try {
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataEngineByQualifiedName");
            response.setGUID(handler.getExternalDataEngineByQualifiedName(userId, qualifiedName));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"getExternalDataEngineByQualifiedName", (Object)response);
        return response;
    }

    public GUIDResponse createOrUpdateSchemaType(String userId, String serverName, SchemaTypeRequestBody schemaTypeRequestBody) {
        String methodName = "createOrUpdateSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdateSchemaType");
        GUIDResponse response = new GUIDResponse();
        try {
            if (schemaTypeRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdateSchemaType", serverName);
                return response;
            }
            String newSchemaTypeGUID = this.createOrUpdateSchemaType(userId, serverName, schemaTypeRequestBody.getSchemaType(), schemaTypeRequestBody.getExternalSourceName());
            response.setGUID(newSchemaTypeGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdateSchemaType", (Object)response);
        return response;
    }

    public GUIDResponse createOrUpdatePortImplementation(String userId, String serverName, PortImplementationRequestBody portImplementationRequestBody) {
        String methodName = "createOrUpdatePortImplementation";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortImplementation");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portImplementationRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdatePortImplementation", serverName);
                return response;
            }
            String portImplementationGUID = this.createOrUpdatePortImplementationWithSchemaType(userId, serverName, portImplementationRequestBody.getPortImplementation(), portImplementationRequestBody.getExternalSourceName());
            response.setGUID(portImplementationGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdatePortImplementation", (Object)response);
        return response;
    }

    public GUIDResponse createOrUpdatePortAlias(String userId, String serverName, PortAliasRequestBody portAliasRequestBody) {
        String methodName = "createOrUpdatePortAliasWithDelegation";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortAliasWithDelegation");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portAliasRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdatePortAliasWithDelegation", serverName);
                return response;
            }
            response.setGUID(this.createOrUpdatePortAliasWithDelegation(userId, serverName, portAliasRequestBody.getPortAlias(), portAliasRequestBody.getExternalSourceName()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdatePortAliasWithDelegation", (Object)response);
        return response;
    }

    public ProcessListResponse createOrUpdateProcesses(String userId, String serverName, ProcessesRequestBody processesRequestBody) {
        String methodName = "createOrUpdateProcesses";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdateProcesses");
        ProcessListResponse response = new ProcessListResponse();
        try {
            if (processesRequestBody == null || CollectionUtils.isEmpty((Collection)processesRequestBody.getProcesses())) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createOrUpdateProcesses", serverName);
                return response;
            }
            return this.createOrUpdateProcesses(userId, serverName, processesRequestBody.getProcesses(), processesRequestBody.getExternalSourceName());
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdateProcesses", (Object)response);
            return response;
        }
    }

    public String createOrUpdatePortAliasWithDelegation(String userId, String serverName, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portAliasGUID;
        String methodName = "createOrUpdatePortAliasWithDelegation";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortAliasWithDelegation");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "createOrUpdatePortAliasWithDelegation");
        Optional<EntityDetail> portEntity = portHandler.findPortAliasEntity(userId, portAlias.getQualifiedName());
        if (!portEntity.isPresent()) {
            portAliasGUID = portHandler.createPortAlias(userId, portAlias, externalSourceName);
        } else {
            portAliasGUID = portEntity.get().getGUID();
            portHandler.updatePortAlias(userId, portEntity.get(), portAlias);
        }
        if (!StringUtils.isEmpty((CharSequence)portAlias.getDelegatesTo())) {
            portHandler.addPortDelegationRelationship(userId, portAliasGUID, portAlias.getPortType(), portAlias.getDelegatesTo(), externalSourceName);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdatePortAliasWithDelegation", (Object)portAliasGUID);
        return portAliasGUID;
    }

    public String createOrUpdatePortImplementationWithSchemaType(String userId, String serverName, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portImplementationGUID;
        String methodName = "createOrUpdatePortImplementationWithSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortImplementationWithSchemaType");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "createOrUpdatePortImplementationWithSchemaType");
        String schemaTypeGUID = this.createOrUpdateSchemaType(userId, serverName, portImplementation.getSchemaType(), externalSourceName);
        Optional<EntityDetail> portEntity = portHandler.findPortImplementationEntity(userId, portImplementation.getQualifiedName());
        if (!portEntity.isPresent()) {
            portImplementationGUID = portHandler.createPortImplementation(userId, portImplementation, externalSourceName);
        } else {
            portImplementationGUID = portEntity.get().getGUID();
            portHandler.updatePortImplementation(userId, portEntity.get(), portImplementation);
            if (portImplementation.getUpdateSemantic() == UpdateSemantic.REPLACE) {
                this.deleteObsoleteSchemaType(userId, serverName, schemaTypeGUID, portHandler.findSchemaTypeForPort(userId, portImplementationGUID));
            }
        }
        portHandler.addPortSchemaRelationship(userId, portImplementationGUID, schemaTypeGUID, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdatePortImplementationWithSchemaType", (Object)portImplementationGUID);
        return portImplementationGUID;
    }

    public String createExternalDataEngine(String userId, String serverName, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createExternalDataEngine";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createExternalDataEngine");
        if (softwareServerCapability == null) {
            return null;
        }
        DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataEngine");
        return handler.createOrUpdateExternalDataEngine(userId, softwareServerCapability);
    }

    public void addPortsToProcess(String userId, String serverName, String processGUID, List<String> portQualifiedNames, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addPortsToProcess";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"addPortsToProcess");
        if (CollectionUtils.isEmpty(portQualifiedNames)) {
            return;
        }
        ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addPortsToProcess");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "addPortsToProcess");
        for (String portQualifiedName : portQualifiedNames) {
            Optional<EntityDetail> portEntity = portHandler.findPortEntity(userId, portQualifiedName);
            if (!portEntity.isPresent()) continue;
            processHandler.addProcessPortRelationship(userId, processGUID, portEntity.get().getGUID(), externalSourceName);
        }
    }

    public void addLineageMappings(String userId, String serverName, List<LineageMapping> lineageMappings, FFDCResponseBase response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLineageMappings";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"addLineageMappings");
        if (CollectionUtils.isEmpty(lineageMappings)) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addLineageMappings");
        lineageMappings.parallelStream().forEach(lineageMapping -> {
            try {
                dataEngineSchemaTypeHandler.addLineageMappingRelationship(userId, lineageMapping.getSourceAttribute(), lineageMapping.getTargetAttribute(), externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException(response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException(response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException(response, error);
            }
        });
    }

    public ProcessListResponse createOrUpdateProcesses(String userId, String serverName, List<Process> processes, String externalSourceName) {
        Predicate<Process> hasPortImplementationsPredicate = process -> CollectionUtils.isNotEmpty((Collection)process.getPortImplementations());
        Map<Boolean, List<Process>> partitionedProcesses = processes.parallelStream().collect(Collectors.partitioningBy(hasPortImplementationsPredicate));
        ArrayList createdProcesses = new ArrayList();
        ArrayList<GUIDResponse> failedProcesses = new ArrayList<GUIDResponse>();
        Consumer<Process> processConsumer = process -> {
            GUIDResponse guidResponse = this.createOrUpdateProcess(userId, serverName, (Process)process, externalSourceName);
            if (guidResponse.getRelatedHTTPCode() == HttpStatus.OK.value()) {
                String processGUID = guidResponse.getGUID();
                process.setGUID(processGUID);
                VoidResponse updateStatusResponse = this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE);
                if (updateStatusResponse.getRelatedHTTPCode() != 200) {
                    this.captureException((FFDCResponseBase)updateStatusResponse, (FFDCResponseBase)guidResponse);
                }
                createdProcesses.add(guidResponse);
            } else {
                failedProcesses.add(guidResponse);
            }
        };
        partitionedProcesses.get(Boolean.TRUE).parallelStream().forEach(processConsumer);
        partitionedProcesses.get(Boolean.FALSE).forEach(processConsumer);
        ProcessListResponse response = new ProcessListResponse();
        response.setGUIDs(createdProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        this.handleFailedProcesses(response, failedProcesses);
        this.addProcessHierarchyRelationships(userId, serverName, processes, response, externalSourceName);
        return response;
    }

    public GUIDResponse addPortsToProcess(String userId, String serverName, String processGuid, PortListRequestBody portListRequestBody) {
        String methodName = "addPortsToProcess";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"addPortsToProcess");
        GUIDResponse response = new GUIDResponse();
        try {
            if (portListRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addPortsToProcess", serverName);
                return response;
            }
            this.addPortsToProcess(userId, serverName, processGuid, portListRequestBody.getPorts(), portListRequestBody.getExternalSourceName());
            response.setGUID(processGuid);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addPortsToProcess", (Object)response);
        return response;
    }

    public VoidResponse addLineageMappings(String userId, String serverName, LineageMappingsRequestBody lineageMappingsRequestBody) {
        String methodName = "addLineageMappings";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"addLineageMappings");
        VoidResponse response = new VoidResponse();
        try {
            if (lineageMappingsRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLineageMappings", serverName);
                return response;
            }
            this.addLineageMappings(userId, serverName, lineageMappingsRequestBody.getLineageMappings(), (FFDCResponseBase)response, lineageMappingsRequestBody.getExternalSourceName());
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addLineageMappings", (Object)response);
        return response;
    }

    private String createOrUpdateSchemaType(String userId, String serverName, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdateSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdateSchemaType");
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "createOrUpdateSchemaType");
        String schemaTypeGUID = dataEngineSchemaTypeHandler.createOrUpdateSchemaType(userId, schemaType, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdateSchemaType", (Object)schemaTypeGUID);
        return schemaTypeGUID;
    }

    private void deleteObsoleteSchemaType(String userId, String serverName, String schemaTypeGUID, String oldSchemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteObsoleteSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"deleteObsoleteSchemaType");
        if (!oldSchemaTypeGUID.equalsIgnoreCase(schemaTypeGUID)) {
            DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteObsoleteSchemaType");
            dataEngineSchemaTypeHandler.removeSchemaType(userId, oldSchemaTypeGUID);
        }
        log.debug(DEBUG_METHOD_RETURN_VOID_RESPONSE, (Object)"deleteObsoleteSchemaType");
    }

    private void handleFailedProcesses(ProcessListResponse response, List<GUIDResponse> failedProcesses) {
        response.setFailedGUIDs(failedProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        failedProcesses.parallelStream().forEach(guidResponse -> this.captureException((FFDCResponseBase)guidResponse, (FFDCResponseBase)response));
    }

    private void captureException(FFDCResponseBase initialResponse, FFDCResponseBase response) {
        response.setExceptionErrorMessage(initialResponse.getExceptionErrorMessage());
        response.setExceptionClassName(initialResponse.getExceptionClassName());
        response.setExceptionSystemAction(initialResponse.getExceptionSystemAction());
        response.setExceptionUserAction(initialResponse.getExceptionUserAction());
        response.setRelatedHTTPCode(initialResponse.getRelatedHTTPCode());
        response.setExceptionProperties(initialResponse.getExceptionProperties());
    }

    private VoidResponse updateProcessStatus(String userId, String serverName, String processGUID, InstanceStatus instanceStatus) {
        String methodName = "updateProcessStatus";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"updateProcessStatus");
        VoidResponse response = new VoidResponse();
        try {
            ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "updateProcessStatus");
            processHandler.updateProcessStatus(userId, processGUID, instanceStatus);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"updateProcessStatus", (Object)response);
        return response;
    }

    private GUIDResponse createOrUpdateProcess(String userId, String serverName, Process process, String externalSourceName) {
        String methodName = "createOrUpdateProcess";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdateProcess");
        String qualifiedName = process.getQualifiedName();
        List portImplementations = process.getPortImplementations();
        List portAliases = process.getPortAliases();
        List lineageMappings = process.getLineageMappings();
        UpdateSemantic updateSemantic = process.getUpdateSemantic();
        GUIDResponse response = new GUIDResponse();
        try {
            String processGUID;
            Set<String> portImplementationGUIDs = this.createOrUpdatePortImplementations(userId, serverName, portImplementations, response, externalSourceName);
            Set<String> portAliasGUIDs = this.createOrUpdatePortAliases(userId, serverName, portAliases, response, externalSourceName);
            if (response.getRelatedHTTPCode() != HttpStatus.OK.value()) {
                return response;
            }
            ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "createOrUpdateProcess");
            Optional<EntityDetail> processEntity = processHandler.findProcessEntity(userId, qualifiedName);
            if (!processEntity.isPresent()) {
                processGUID = processHandler.createProcess(userId, process, externalSourceName);
            } else {
                processGUID = processEntity.get().getGUID();
                processHandler.updateProcess(userId, processEntity.get(), process);
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.DRAFT);
                if (updateSemantic == UpdateSemantic.REPLACE) {
                    this.deleteObsoletePorts(userId, serverName, portImplementationGUIDs, processGUID, "PortImplementation", response);
                    this.deleteObsoletePorts(userId, serverName, portAliasGUIDs, processGUID, "PortAlias", response);
                }
            }
            this.addProcessPortRelationships(userId, serverName, processGUID, Stream.concat(portImplementationGUIDs.stream(), portAliasGUIDs.stream()).collect(Collectors.toSet()), response, externalSourceName);
            this.addLineageMappings(userId, serverName, lineageMappings, (FFDCResponseBase)response, externalSourceName);
            response.setGUID(processGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createOrUpdateProcess", (Object)response);
        return response;
    }

    private void addProcessHierarchyRelationships(String userId, String serverName, List<Process> processes, ProcessListResponse response, String externalSourceName) {
        String methodName = "addProcessHierarchyRelationships";
        ArrayList failedGUIDS = new ArrayList();
        processes.parallelStream().filter(process -> response.getGUIDs().contains(process.getGUID())).forEach(process -> {
            List parentProcesses = process.getParentProcesses();
            String processGUID = process.getGUID();
            if (CollectionUtils.isNotEmpty((Collection)parentProcesses)) {
                try {
                    ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyRelationships");
                    for (ParentProcess parentProcess : parentProcesses) {
                        processHandler.createOrUpdateProcessHierarchyRelationship(userId, parentProcess, processGUID, externalSourceName);
                    }
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
                }
            }
            if (response.getRelatedHTTPCode() != HttpStatus.OK.value()) {
                this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.DRAFT);
                failedGUIDS.add(processGUID);
            }
        });
        response.getGUIDs().removeAll(failedGUIDS);
        response.getFailedGUIDs().addAll(failedGUIDS);
    }

    private void addProcessPortRelationships(String userId, String serverName, String processGUID, Set<String> portGUIDs, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessPortRelationships";
        ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessPortRelationships");
        portGUIDs.parallelStream().forEach(portGUID -> {
            try {
                processHandler.addProcessPortRelationship(userId, processGUID, (String)portGUID, externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
            }
        });
    }

    private void deleteObsoletePorts(String userId, String serverName, Set<String> newPortGUIDs, String processGUID, String portTypeName, GUIDResponse response) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteObsoletePorts";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"deleteObsoletePorts");
        if (CollectionUtils.isEmpty(newPortGUIDs)) {
            return;
        }
        ProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteObsoletePorts");
        PortHandler portHandler = this.instanceHandler.getPortHandler(userId, serverName, "deleteObsoletePorts");
        Set<String> oldPortGUIDs = processHandler.getPortsForProcess(userId, processGUID, portTypeName);
        List<String> obsoletePorts = oldPortGUIDs.parallelStream().collect(Collectors.partitioningBy(newPortGUIDs::contains)).get(Boolean.FALSE);
        obsoletePorts.parallelStream().forEach(portGUID -> {
            try {
                portHandler.removePort(userId, (String)portGUID, portTypeName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
            }
        });
        log.debug(DEBUG_METHOD_RETURN_VOID_RESPONSE, (Object)"deleteObsoletePorts");
    }

    private Set<String> createOrUpdatePortImplementations(String userId, String serverName, List<PortImplementation> portImplementations, GUIDResponse response, String externalSourceName) {
        String methodName = "createOrUpdatePortImplementations";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortImplementations");
        HashSet<String> portImplementationGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portImplementations)) {
            portImplementations.parallelStream().forEach(portImplementation -> {
                try {
                    portImplementationGUIDs.add(this.createOrUpdatePortImplementationWithSchemaType(userId, serverName, (PortImplementation)portImplementation, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
                }
            });
        }
        return portImplementationGUIDs;
    }

    private Set<String> createOrUpdatePortAliases(String userId, String serverName, List<PortAlias> portAliases, GUIDResponse response, String externalSourceName) {
        String methodName = "createOrUpdatePortAliases";
        log.debug(DEBUG_MESSAGE_METHOD, (Object)"createOrUpdatePortAliases");
        HashSet<String> portAliasGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portAliases)) {
            portAliases.parallelStream().forEach(portAlias -> {
                try {
                    portAliasGUIDs.add(this.createOrUpdatePortAliasWithDelegation(userId, serverName, (PortAlias)portAlias, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
                }
            });
        }
        return portAliasGUIDs;
    }
}

