/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Port;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.PortType;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.PortPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PortHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public PortHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String createPortImplementation(String userId, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, (Port)portImplementation, "PortImplementation", externalSourceName);
    }

    public String createPortAlias(String userId, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createPort(userId, (Port)portAlias, "PortAlias", externalSourceName);
    }

    public void updatePortImplementation(String userId, EntityDetail originalPortEntity, PortImplementation portImplementation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, originalPortEntity, (Port)portImplementation, "PortImplementation");
    }

    public void updatePortAlias(String userId, EntityDetail originalPortEntity, PortAlias portAlias) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updatePort(userId, originalPortEntity, (Port)portAlias, "PortAlias");
    }

    private String createPort(String userId, Port port, String entityTpeName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "createPort");
        PortPropertiesBuilder builder = new PortPropertiesBuilder(port.getQualifiedName(), port.getDisplayName(), port.getPortType(), this.repositoryHelper, this.serviceName, this.serverName);
        return this.dataEngineCommonHandler.createExternalEntity(userId, builder.getInstanceProperties("createPort"), InstanceStatus.ACTIVE, entityTpeName, externalSourceName);
    }

    private void updatePort(String userId, EntityDetail originalPortEntity, Port port, String entityTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        this.validatePortParameters(userId, port.getQualifiedName(), port.getDisplayName(), "updatePort");
        String portGUID = originalPortEntity.getGUID();
        PortPropertiesBuilder updatedPortBuilder = new PortPropertiesBuilder(port.getQualifiedName(), port.getDisplayName(), port.getPortType(), this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail updatedPortEntity = this.dataEngineCommonHandler.buildEntityDetail(portGUID, updatedPortBuilder.getInstanceProperties("updatePort"));
        EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalPortEntity, updatedPortEntity, true);
        if (!entityDetailDifferences.hasInstancePropertiesDifferences()) {
            return;
        }
        this.dataEngineCommonHandler.updateEntity(userId, portGUID, updatedPortBuilder.getInstanceProperties("updatePort"), entityTypeName);
    }

    public void addPortSchemaRelationship(String userId, String portGUID, String schemaTypeGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataEngineCommonHandler.createOrUpdateExternalRelationship(userId, portGUID, schemaTypeGUID, "PortSchema", "Port", externalSourceName, null);
    }

    public String findSchemaTypeForPort(String userId, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaTypeForPort";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaTypeForPort");
        this.invalidParameterHandler.validateGUID(portGUID, "guid", "findSchemaTypeForPort");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "PortSchema");
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, portGUID, "Port", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "findSchemaTypeForPort");
        if (entity == null) {
            return null;
        }
        return entity.getGUID();
    }

    public void addPortDelegationRelationship(String userId, String portGUID, PortType portType, String delegatesToQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addPortDelegationRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addPortDelegationRelationship");
        this.invalidParameterHandler.validateName(delegatesToQualifiedName, "qualifiedName", "addPortDelegationRelationship");
        Optional<EntityDetail> delegatedPortEntity = this.findPortEntity(userId, delegatesToQualifiedName);
        if (delegatedPortEntity.isPresent()) {
            String delegatedPortType = this.getPortType(delegatedPortEntity.get());
            if (portType.getName().equalsIgnoreCase(delegatedPortType)) {
                this.dataEngineCommonHandler.createOrUpdateExternalRelationship(userId, portGUID, delegatedPortEntity.get().getGUID(), "PortDelegation", "Port", externalSourceName, null);
            } else {
                this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.INVALID_PORT_TYPE, "addPortDelegationRelationship", delegatesToQualifiedName, delegatedPortType);
            }
        } else {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.PORT_NOT_FOUND, "addPortDelegationRelationship", delegatesToQualifiedName, portGUID);
        }
    }

    public void removePort(String userId, String portGUID, String entityTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.dataEngineCommonHandler.removeEntity(userId, portGUID, entityTypeName);
    }

    public Optional<EntityDetail> findPortImplementationEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "PortImplementation");
    }

    public Optional<EntityDetail> findPortAliasEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "PortAlias");
    }

    public Optional<EntityDetail> findPortEntity(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Optional<EntityDetail> portEntity = this.findPortAliasEntity(userId, qualifiedName);
        if (!portEntity.isPresent()) {
            portEntity = this.findPortImplementationEntity(userId, qualifiedName);
        }
        return portEntity;
    }

    private String getPortType(EntityDetail delegatedPort) {
        if (delegatedPort == null) {
            return null;
        }
        InstanceProperties instanceProperties = delegatedPort.getProperties();
        if (instanceProperties == null) {
            return null;
        }
        EnumPropertyValue portTypeValue = (EnumPropertyValue)delegatedPort.getProperties().getPropertyValue("portType");
        if (portTypeValue == null) {
            return null;
        }
        return portTypeValue.getSymbolicName();
    }

    private void validatePortParameters(String userId, String qualifiedName, String displayName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(displayName, "displayName", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }
}

