/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ComplexSchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineSchemaTypeHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final SchemaTypeHandler schemaTypeHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;

    public DataEngineSchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, SchemaTypeHandler schemaTypeHandler, DataEngineRegistrationHandler dataEngineRegistrationHandler, DataEngineCommonHandler dataEngineCommonHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
    }

    public String createOrUpdateSchemaType(String userId, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID;
        String methodName = "createOrUpdateSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getQualifiedName(), "qualifiedName", "createOrUpdateSchemaType");
        this.invalidParameterHandler.validateName(schemaType.getDisplayName(), "displayName", "createOrUpdateSchemaType");
        org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType schemaTypeBean = this.createTabularSchemaType(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getAuthor(), schemaType.getEncodingStandard(), schemaType.getUsage(), schemaType.getVersionNumber());
        Optional<EntityDetail> originalSchemaTypeEntity = this.findSchemaTypeEntity(userId, schemaTypeBean.getQualifiedName());
        if (!originalSchemaTypeEntity.isPresent()) {
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            schemaTypeGUID = this.schemaTypeHandler.addExternalSchemaType(userId, schemaTypeBean, externalSourceGUID, externalSourceName);
        } else {
            schemaTypeGUID = originalSchemaTypeEntity.get().getGUID();
            EntityDetail updatedSchemaTypeEntity = this.buildSchemaTypeEntityDetail(schemaTypeGUID, schemaTypeBean);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalSchemaTypeEntity.get(), updatedSchemaTypeEntity, true);
            if (entityDetailDifferences.hasInstancePropertiesDifferences()) {
                this.schemaTypeHandler.updateSchemaType(userId, schemaTypeGUID, schemaTypeBean);
            }
        }
        this.createOrUpdateSchemaAttributes(userId, schemaTypeGUID, schemaType.getAttributeList(), externalSourceName);
        return schemaTypeGUID;
    }

    public Optional<EntityDetail> findSchemaTypeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaType");
    }

    public Optional<EntityDetail> findSchemaAttributeEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "SchemaAttribute");
    }

    public void addLineageMappingRelationship(String userId, String sourceSchemaAttributeQualifiedName, String targetSchemaAttributeQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addLineageMappingRelationship";
        this.invalidParameterHandler.validateUserId(userId, "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(sourceSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        this.invalidParameterHandler.validateName(targetSchemaAttributeQualifiedName, "qualifiedName", "addLineageMappingRelationship");
        Optional<EntityDetail> sourceSchemaAttributeEntity = this.findSchemaAttributeEntity(userId, sourceSchemaAttributeQualifiedName);
        Optional<EntityDetail> targetSchemaAttributeEntity = this.findSchemaAttributeEntity(userId, targetSchemaAttributeQualifiedName);
        if (!sourceSchemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addLineageMappingRelationship", sourceSchemaAttributeQualifiedName);
            return;
        }
        if (!targetSchemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addLineageMappingRelationship", targetSchemaAttributeQualifiedName);
            return;
        }
        this.dataEngineCommonHandler.createOrUpdateExternalRelationship(userId, sourceSchemaAttributeEntity.get().getGUID(), targetSchemaAttributeEntity.get().getGUID(), "LineageMapping", "SchemaAttribute", externalSourceName, null);
    }

    public void removeSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "removeSchemaType");
        Set<String> schemaAttributeGUIDs = this.getSchemaAttributesForSchemaType(userId, schemaTypeGUID);
        for (String schemaAttributeGUID : schemaAttributeGUIDs) {
            this.removeTabularColumn(userId, schemaAttributeGUID);
        }
        this.removeTabularSchemaType(userId, schemaTypeGUID);
    }

    public void addAnchorGUID(String userId, Attribute attribute, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnchorGUID";
        SchemaAttribute schemaAttribute = this.createTabularColumn(attribute);
        schemaAttribute.setAnchorGUID(processGUID);
        Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, attribute.getQualifiedName());
        if (!schemaAttributeEntity.isPresent()) {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.SCHEMA_ATTRIBUTE_NOT_FOUND, "addAnchorGUID", new String[0]);
        } else {
            this.schemaTypeHandler.updateSchemaAttribute(userId, schemaAttributeEntity.get().getGUID(), schemaAttribute);
        }
    }

    private void createOrUpdateSchemaAttributes(String userId, String schemaTypeGUID, List<Attribute> attributeList, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        for (Attribute attribute : attributeList) {
            SchemaAttribute schemaAttribute = this.createTabularColumn(attribute);
            Optional<EntityDetail> schemaAttributeEntity = this.findSchemaAttributeEntity(userId, schemaAttribute.getQualifiedName());
            if (!schemaAttributeEntity.isPresent()) {
                this.createSchemaAttribute(userId, schemaTypeGUID, schemaAttribute, attribute.getDataType(), externalSourceName);
                continue;
            }
            String schemaAttributeGUID = schemaAttributeEntity.get().getGUID();
            EntityDetail updatedSchemaAttributeEntity = this.buildSchemaAttributeEntityDetail(schemaAttributeGUID, schemaAttribute);
            EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(schemaAttributeEntity.get(), updatedSchemaAttributeEntity, true);
            if (!entityDetailDifferences.hasInstancePropertiesDifferences()) continue;
            this.schemaTypeHandler.updateSchemaAttribute(userId, schemaAttributeGUID, schemaAttribute);
        }
    }

    private EntityDetail buildSchemaAttributeEntityDetail(String schemaAttributeGUID, SchemaAttribute schemaAttribute) throws InvalidParameterException {
        String methodName = "buildSchemaAttributeEntityDetail";
        SchemaAttributeBuilder builder = this.schemaTypeHandler.getSchemaAttributeBuilder(schemaAttribute);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaAttributeGUID, builder.getInstanceProperties(methodName));
    }

    private String createSchemaAttribute(String userId, String schemaTypeGUID, SchemaAttribute schemaAttribute, String dataType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        String schemaAttributeGUID = this.schemaTypeHandler.addExternalSchemaAttribute(userId, schemaAttribute, externalSourceGUID, externalSourceName);
        this.repositoryHandler.createExternalRelationship(userId, "86b176a2-015c-44a6-8106-54d5d69ba661", externalSourceGUID, externalSourceName, schemaTypeGUID, schemaAttributeGUID, null, "createSchemaAttribute");
        TypeDef classificationTypeDef = this.repositoryHelper.getTypeDefByName(userId, "TypeEmbeddedAttribute");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "dataType", dataType, "createSchemaAttribute");
        this.repositoryHandler.classifyEntity(userId, schemaAttributeGUID, classificationTypeDef.getGUID(), classificationTypeDef.getName(), properties, "createSchemaAttribute");
        return schemaAttributeGUID;
    }

    private EntityDetail buildSchemaTypeEntityDetail(String schemaTypeGUID, org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType schemaType) throws InvalidParameterException {
        String methodName = "buildSchemaTypeEntityDetail";
        ComplexSchemaTypeBuilder builder = new ComplexSchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getVersionNumber(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        return this.dataEngineCommonHandler.buildEntityDetail(schemaTypeGUID, builder.getInstanceProperties(methodName));
    }

    private Set<String> getSchemaAttributesForSchemaType(String userId, String schemaTypeGUID) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "getSchemaAttributesForSchemaType";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesForSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "guid", "getSchemaAttributesForSchemaType");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "AttributeForSchema");
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaTypeGUID, "SchemaType", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getSchemaAttributesForSchemaType");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private void removeTabularColumn(String userId, String tabularColumnGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.dataEngineCommonHandler.removeEntity(userId, tabularColumnGUID, "TabularColumn");
    }

    private SchemaAttribute createTabularColumn(Attribute attribute) throws InvalidParameterException {
        String methodName = "createTabularColumns";
        SchemaAttribute schemaAttribute = this.schemaTypeHandler.getEmptyTabularColumn();
        String qualifiedName = attribute.getQualifiedName();
        String displayName = attribute.getDisplayName();
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createTabularColumns");
        this.invalidParameterHandler.validateName(displayName, "displayName", "createTabularColumns");
        schemaAttribute.setQualifiedName(qualifiedName);
        schemaAttribute.setAttributeName(displayName);
        schemaAttribute.setDefaultValueOverride(attribute.getDefaultValueOverride());
        schemaAttribute.setElementPosition(attribute.getPosition());
        schemaAttribute.setMaxCardinality(attribute.getMaxCardinality());
        schemaAttribute.setMaxCardinality(attribute.getMinCardinality());
        schemaAttribute.setAllowsDuplicateValues(attribute.getAllowsDuplicateValues());
        schemaAttribute.setOrderedValues(attribute.getOrderedValues());
        return schemaAttribute;
    }

    private org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType createTabularSchemaType(String qualifiedName, String displayName, String author, String encodingStandard, String usage, String versionNumber) {
        ComplexSchemaType schemaType = this.schemaTypeHandler.getEmptyComplexSchemaType("248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType");
        schemaType.setQualifiedName(qualifiedName);
        schemaType.setDisplayName(displayName);
        schemaType.setAuthor(author);
        schemaType.setEncodingStandard(encodingStandard);
        schemaType.setUsage(usage);
        schemaType.setVersionNumber(versionNumber);
        return schemaType;
    }

    private void removeTabularSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.dataEngineCommonHandler.removeEntity(userId, schemaTypeGUID, "TabularSchemaType");
    }
}

