/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.connectors.intopic.DataEngineInTopicClientProvider;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.listeners.DataEngineInTopicListener;
import org.odpi.openmetadata.accessservices.dataengine.server.processors.DataEngineEventProcessor;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog;
    private DataEngineServicesInstance instance;
    private String serverName;
    private static final Logger log = LoggerFactory.getLogger(DataEngineAdmin.class);

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DataEngineAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DataEngineServicesInstance(repositoryConnector, supportedZones, defaultZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), super.getOutTopicConnection(accessServiceConfig.getAccessServiceInTopic(), AccessServiceDescription.DATA_ENGINE_OMAS.getAccessServiceFullName(), DataEngineInTopicClientProvider.class.getName(), auditLog));
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceInTopic() != null) {
                DataEngineEventProcessor dataEngineEventProcessor = new DataEngineEventProcessor(this.instance, auditLog);
                DataEngineInTopicListener dataEngineInTopicListener = new DataEngineInTopicListener(auditLog, dataEngineEventProcessor);
                OpenMetadataTopicConnector dataEngineInTopicConnector = this.initializeDataEngineTopicConnector(accessServiceConfig.getAccessServiceInTopic());
                if (dataEngineInTopicConnector != null) {
                    dataEngineInTopicConnector.registerListener((OpenMetadataTopicListener)dataEngineInTopicListener);
                    dataEngineInTopicConnector.start();
                }
            }
            auditLog.logMessage("initialize", DataEngineAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException e) {
            throw e;
        }
        catch (Exception error) {
            auditLog.logException("initialize", DataEngineAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage(), this.serverName}), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.DATA_ENGINE_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            this.auditLog.logMessage("shutdown", DataEngineAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(this.auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Exception error) {
            String methodName = "getTopicConnector";
            OMAGConfigurationErrorException e = new OMAGConfigurationErrorException(DataEngineErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName);
            log.error("Exception in returning the topic connector for Data Engine: ", (Throwable)error);
            throw e;
        }
    }

    private OpenMetadataTopicConnector initializeDataEngineTopicConnector(Connection topicConnection) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        if (topicConnection != null) {
            try {
                return this.getTopicConnector(topicConnection);
            }
            catch (Exception e) {
                this.auditLog.logException("initialize", DataEngineAuditCode.ERROR_INITIALIZING_TOPIC_CONNECTION.getMessageDefinition(new String[]{e.getMessage(), this.serverName}), (Throwable)e);
                throw e;
            }
        }
        return null;
    }
}

