/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.model.Connection;
import org.odpi.openmetadata.accessservices.dataengine.model.Endpoint;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ConnectionBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.EndpointBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataEngineConnectionAndEndpointHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;
    private final String serverName;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private final ReferenceableHandler<Connection> connectionHandler;
    private final ReferenceableHandler<Endpoint> endpointHandler;

    public DataEngineConnectionAndEndpointHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, DataEngineCommonHandler dataEngineCommonHandler, ReferenceableHandler<Connection> connectionHandler, ReferenceableHandler<Endpoint> endpointHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.connectionHandler = connectionHandler;
        this.endpointHandler = endpointHandler;
    }

    public void upsertConnectionAndEndpoint(String assetQualifiedName, String assetTypeName, String protocol, String networkAddress, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.validateParameters(assetQualifiedName, assetTypeName, protocol, networkAddress, externalSourceGuid, externalSourceName, userId, methodName);
        Optional<EntityDetail> optionalAsset = this.dataEngineCommonHandler.findEntity(userId, assetQualifiedName, assetTypeName);
        if (!optionalAsset.isPresent()) {
            return;
        }
        String connectionQualifiedName = "Connection::" + protocol + "::" + networkAddress;
        String connectionGuid = this.upsertConnection(externalSourceGuid, externalSourceName, userId, methodName, optionalAsset.get(), connectionQualifiedName);
        String endpointQualifiedName = "Endpoint::" + protocol + "::" + networkAddress;
        this.upsertEndpoint(protocol, networkAddress, externalSourceGuid, externalSourceName, userId, methodName, connectionGuid, endpointQualifiedName);
    }

    private String upsertConnection(String externalSourceGuid, String externalSourceName, String userId, String methodName, EntityDetail asset, String connectionQualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        Optional<EntityDetail> optionalConnection = this.dataEngineCommonHandler.findEntity(userId, connectionQualifiedName, "Connection");
        String connectionGuid = !optionalConnection.isPresent() ? this.createConnection(connectionQualifiedName, externalSourceGuid, externalSourceName, userId, methodName) : optionalConnection.get().getGUID();
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, connectionGuid, asset.getGUID(), "ConnectionToAsset", "Connection", externalSourceName, null);
        return connectionGuid;
    }

    private String createConnection(String qualifiedName, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ConnectionBuilder connectionBuilder = this.getConnectionBuilder(qualifiedName);
        return this.connectionHandler.createBeanInRepository(userId, externalSourceGuid, externalSourceName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", qualifiedName, "qualifiedName", (OpenMetadataAPIGenericBuilder)connectionBuilder, methodName);
    }

    ConnectionBuilder getConnectionBuilder(String qualifiedName) {
        return new ConnectionBuilder(qualifiedName, "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.repositoryHelper, this.serviceName, this.serverName);
    }

    private void upsertEndpoint(String protocol, String networkAddress, String externalSourceGuid, String externalSourceName, String userId, String methodName, String connectionGuid, String endpointQualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String endpointGuid;
        Optional<EntityDetail> optionalEndpoint = this.dataEngineCommonHandler.findEntity(userId, endpointQualifiedName, "Endpoint");
        if (optionalEndpoint.isPresent()) {
            this.updateEndpoint(protocol, networkAddress, endpointQualifiedName, optionalEndpoint.get().getGUID(), externalSourceGuid, externalSourceName, userId, methodName);
            endpointGuid = optionalEndpoint.get().getGUID();
        } else {
            endpointGuid = this.createEndpoint(protocol, networkAddress, endpointQualifiedName, externalSourceGuid, externalSourceName, userId, methodName);
        }
        this.dataEngineCommonHandler.upsertExternalRelationship(userId, endpointGuid, connectionGuid, "ConnectionEndpoint", "Endpoint", externalSourceName, null);
    }

    private String createEndpoint(String protocol, String networkAddress, String qualifiedName, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EndpointBuilder endpointBuilder = this.getEndpointBuilder(protocol, networkAddress, qualifiedName);
        return this.endpointHandler.createBeanInRepository(userId, externalSourceGuid, externalSourceName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", qualifiedName, "qualifiedName", (OpenMetadataAPIGenericBuilder)endpointBuilder, methodName);
    }

    private void updateEndpoint(String protocol, String networkAddress, String qualifiedName, String guid, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EndpointBuilder endpointBuilder = this.getEndpointBuilder(protocol, networkAddress, qualifiedName);
        this.endpointHandler.updateBeanInRepository(userId, externalSourceGuid, externalSourceName, guid, "guid", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", endpointBuilder.getInstanceProperties("updateEndpoint"), false, methodName);
    }

    EndpointBuilder getEndpointBuilder(String protocol, String networkAddress, String qualifiedName) {
        return new EndpointBuilder(protocol, networkAddress, qualifiedName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", this.repositoryHelper, this.serviceName, this.serverName);
    }

    private void validateParameters(String qualifiedName, String typeName, String protocol, String networkAddress, String externalSourceGuid, String externalSourceName, String userId, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(typeName, "typeName", methodName);
        this.invalidParameterHandler.validateName(protocol, "protocol", methodName);
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", methodName);
        this.invalidParameterHandler.validateName(externalSourceGuid, "externalSourceGuid", methodName);
        this.invalidParameterHandler.validateName(externalSourceName, "externalSourceName", methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
    }
}

