/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineRegistrationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.DeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.LineageMappingsEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortAliasEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.PortImplementationEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessHierarchyEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessesDeleteEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.ProcessesEvent;
import org.odpi.openmetadata.accessservices.dataengine.event.SchemaTypeEvent;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineServicesInstance;
import org.odpi.openmetadata.accessservices.dataengine.server.service.DataEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineEventProcessor {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(DataEngineEventProcessor.class);
    private static final String DEBUG_MESSAGE_METHOD = "Calling method: {}";
    private final AuditLog auditLog;
    private final String serverName;
    private DataEngineRESTServices dataEngineRESTServices = new DataEngineRESTServices();

    public DataEngineEventProcessor(DataEngineServicesInstance instance, AuditLog auditLog) throws NewInstanceException {
        this.auditLog = auditLog;
        this.serverName = instance.getServerName();
    }

    public void processDataEngineRegistrationEvent(String dataEngineEvent) {
        String methodName = "processDataEngineRegistrationEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDataEngineRegistrationEvent");
        try {
            DataEngineRegistrationEvent dataEngineRegistrationEvent = (DataEngineRegistrationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DataEngineRegistrationEvent.class);
            this.dataEngineRESTServices.createExternalDataEngine(dataEngineRegistrationEvent.getUserId(), this.serverName, dataEngineRegistrationEvent.getSoftwareServerCapability());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processDataEngineRegistrationEvent", (Exception)e);
        }
    }

    public void processPortAliasEvent(String dataEngineEvent) {
        String methodName = "processPortAliasEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processPortAliasEvent");
        try {
            PortAliasEvent portAliasEvent = (PortAliasEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortAliasEvent.class);
            String processGUID = this.dataEngineRESTServices.getProcessGUID(this.serverName, portAliasEvent.getUserId(), portAliasEvent.getProcessQualifiedName()).orElse(null);
            this.dataEngineRESTServices.upsertPortAliasWithDelegation(portAliasEvent.getUserId(), this.serverName, portAliasEvent.getPort(), processGUID, portAliasEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processPortAliasEvent", (Exception)e);
        }
    }

    public void processProcessHierarchyEvent(String dataEngineEvent) {
        String methodName = "processProcessHierarchyEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processProcessHierarchyEvent");
        try {
            ProcessHierarchyEvent processHierarchyEvent = (ProcessHierarchyEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessHierarchyEvent.class);
            this.dataEngineRESTServices.addProcessHierarchyToProcess(processHierarchyEvent.getUserId(), this.serverName, processHierarchyEvent.getProcessHierarchy(), processHierarchyEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processProcessHierarchyEvent", (Exception)e);
        }
    }

    public void processPortImplementationEvent(String dataEngineEvent) {
        String methodName = "processPortImplementationEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processPortImplementationEvent");
        try {
            PortImplementationEvent portImplementationEvent = (PortImplementationEvent)OBJECT_MAPPER.readValue(dataEngineEvent, PortImplementationEvent.class);
            String processGUID = this.dataEngineRESTServices.getProcessGUID(this.serverName, portImplementationEvent.getUserId(), portImplementationEvent.getProcessQualifiedName()).orElse(null);
            this.dataEngineRESTServices.upsertPortImplementation(portImplementationEvent.getUserId(), this.serverName, portImplementationEvent.getPortImplementation(), processGUID, portImplementationEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processPortImplementationEvent", (Exception)e);
        }
    }

    public void processLineageMappingsEvent(String dataEngineEvent) {
        String methodName = "processLineageMappingsEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processLineageMappingsEvent");
        try {
            LineageMappingsEvent lineageMappingsEvent = (LineageMappingsEvent)OBJECT_MAPPER.readValue(dataEngineEvent, LineageMappingsEvent.class);
            if (CollectionUtils.isEmpty((Collection)lineageMappingsEvent.getLineageMappings())) {
                return;
            }
            FFDCResponseBase response = new FFDCResponseBase();
            this.dataEngineRESTServices.addLineageMappings(lineageMappingsEvent.getUserId(), this.serverName, lineageMappingsEvent.getLineageMappings(), response, lineageMappingsEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(dataEngineEvent, "processLineageMappingsEvent", (Exception)e);
        }
    }

    public void processProcessesEvent(String dataEngineEvent) {
        String methodName = "processProcessesEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processProcessesEvent");
        try {
            ProcessesEvent processesEvent = (ProcessesEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessesEvent.class);
            this.dataEngineRESTServices.upsertProcesses(processesEvent.getUserId(), this.serverName, processesEvent.getProcesses(), processesEvent.getExternalSourceName());
        }
        catch (JsonProcessingException e) {
            log.debug("Exception in parsing event from in Data Engine In Topic", (Throwable)e);
            this.logException(dataEngineEvent, "processProcessesEvent", (Exception)((Object)e));
        }
    }

    public void processSchemaTypeEvent(String schemaTypeEvent) {
        String methodName = "processSchemaTypeEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processSchemaTypeEvent");
        try {
            SchemaTypeEvent schemaEvent = (SchemaTypeEvent)OBJECT_MAPPER.readValue(schemaTypeEvent, SchemaTypeEvent.class);
            String portGUID = null;
            if (StringUtils.isNotEmpty((CharSequence)schemaEvent.getPortQualifiedName())) {
                portGUID = this.dataEngineRESTServices.getPortGUID(this.serverName, schemaEvent.getUserId(), schemaEvent.getPortQualifiedName()).orElse(null);
            }
            this.dataEngineRESTServices.upsertSchemaType(schemaEvent.getUserId(), this.serverName, portGUID, schemaEvent.getSchemaType(), schemaEvent.getExternalSourceName());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            this.logException(schemaTypeEvent, "processSchemaTypeEvent", (Exception)e);
        }
    }

    public void processDeleteSchemaTypeEvent(String dataEngineEvent) {
        String methodName = "processDeleteSchemaTypeEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteSchemaTypeEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteSchemaType(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteSchemaTypeEvent", (Exception)e);
        }
    }

    public void processDeleteDataEngineEvent(String dataEngineEvent) {
        String methodName = "processDeleteDataEngineEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteDataEngineEvent");
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deleteExternalDataEngine(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteDataEngineEvent", (Exception)e);
        }
    }

    public void processDeleteProcessesEvent(String dataEngineEvent) {
        String methodName = "processDeleteProcessesEvent";
        log.trace(DEBUG_MESSAGE_METHOD, (Object)"processDeleteProcessesEvent");
        try {
            ProcessesDeleteEvent deleteEvent = (ProcessesDeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, ProcessesDeleteEvent.class);
            this.dataEngineRESTServices.deleteProcesses(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuids(), deleteEvent.getQualifiedNames(), deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, "processDeleteProcessesEvent", (Exception)e);
        }
    }

    public void processDeletePortImplementationEvent(String dataEngineEvent) {
        String methodName = "processDeletePortImplementationEvent";
        this.deletePort(dataEngineEvent, "processDeletePortImplementationEvent", "PortImplementation");
    }

    public void processDeletePortAliasEvent(String dataEngineEvent) {
        String methodName = "processDeletePortAliasEvent";
        this.deletePort(dataEngineEvent, "processDeletePortAliasEvent", "PortAlias");
    }

    private void deletePort(String dataEngineEvent, String methodName, String portType) {
        log.trace(DEBUG_MESSAGE_METHOD, (Object)methodName);
        try {
            DeleteEvent deleteEvent = (DeleteEvent)OBJECT_MAPPER.readValue(dataEngineEvent, DeleteEvent.class);
            this.dataEngineRESTServices.deletePort(deleteEvent.getUserId(), this.serverName, deleteEvent.getExternalSourceName(), deleteEvent.getGuid(), deleteEvent.getQualifiedName(), portType, deleteEvent.getDeleteSemantic());
        }
        catch (JsonProcessingException | InvalidParameterException | PropertyServerException | UserNotAuthorizedException | EntityNotDeletedException | FunctionNotSupportedException e) {
            this.logException(dataEngineEvent, methodName, (Exception)e);
        }
    }

    private void logException(String dataEngineEvent, String methodName, Exception e) {
        log.debug("Exception in processing {} from in Data Engine In Topic: {}", (Object)dataEngineEvent, (Object)e);
        this.auditLog.logException(methodName, DataEngineAuditCode.PARSE_EVENT_EXCEPTION.getMessageDefinition(new String[]{dataEngineEvent, e.toString()}), (Throwable)e);
    }
}

