/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.CSVFile;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.Port;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.Referenceable;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineOMASAPIRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DatabaseRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessHierarchyRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesDeleteRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.RelationalTableRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCollectionHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineDataFileHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEnginePortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRelationalDataHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DataEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRESTServices.class);
    private static final String DEBUG_MESSAGE_METHOD_DETAILS = "Calling method {} for entity: {}";
    private static final String DEBUG_MESSAGE_METHOD_RETURN = "Returning from method: {} with response: {}";
    public static final String EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING = "Exception while adding lineage mapping {} : {}";
    public static final String EXCEPTION_WHILE_CREATING_PROCESS = "Exception while creating process {} : {}";
    public static final String EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY = "Exception while creating process relationships for process {} : {}";
    private static final String DEBUG_DELETE_MESSAGE = "DataEngine OMAS deleted entity with GUID {}";
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createExternalDataEngine(String serverName, String userId, DataEngineRegistrationRequestBody requestBody) {
        String methodName = "createExternalDataEngine";
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataEngine", serverName);
                return response;
            }
            response.setGUID(this.createExternalDataEngine(userId, serverName, requestBody.getSoftwareServerCapability()));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "createExternalDataEngine");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createExternalDataEngine", (Object)response);
        return response;
    }

    public GUIDResponse getExternalDataEngine(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataEngineByQualifiedName";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"getExternalDataEngineByQualifiedName", (Object)qualifiedName);
        GUIDResponse response = new GUIDResponse();
        try {
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataEngineByQualifiedName");
            response.setGUID(handler.getExternalDataEngine(userId, qualifiedName));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getExternalDataEngineByQualifiedName");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"getExternalDataEngineByQualifiedName", (Object)response);
        return response;
    }

    public VoidResponse deleteExternalDataEngine(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteExternalDataEngine";
        VoidResponse response = new VoidResponse();
        try {
            this.deleteExternalDataEngine(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteExternalDataEngine");
        }
        return response;
    }

    public void deleteExternalDataEngine(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException {
        String methodName = "deleteExternalDataEngine";
        DataEngineRegistrationHandler dataEngineRegistrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, "deleteExternalDataEngine");
        Optional<String> dataEngineGUID = Optional.ofNullable(guid);
        if (!dataEngineGUID.isPresent()) {
            dataEngineGUID = Optional.ofNullable(dataEngineRegistrationHandler.getExternalDataEngine(userId, qualifiedName));
        }
        if (!dataEngineGUID.isPresent()) {
            return;
        }
        dataEngineRegistrationHandler.removeExternalDataEngine(userId, qualifiedName, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)guid);
    }

    public Optional<String> getProcessGUID(String serverName, String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getProcessGUID";
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            return Optional.empty();
        }
        DataEngineProcessHandler handler = this.instanceHandler.getProcessHandler(userId, serverName, "getProcessGUID");
        Optional<EntityDetail> processEntity = handler.findProcessEntity(userId, qualifiedName);
        return processEntity.map(InstanceHeader::getGUID);
    }

    public Optional<String> getPortGUID(String serverName, String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPortGUID";
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            return Optional.empty();
        }
        DataEnginePortHandler handler = this.instanceHandler.getPortHandler(userId, serverName, "getPortGUID");
        Optional<EntityDetail> portEntity = handler.findPortEntity(userId, qualifiedName);
        return portEntity.map(InstanceHeader::getGUID);
    }

    public Optional<String> getSchemaTypeGUID(String serverName, String userId, String qualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSchemaTypeGUID";
        if (StringUtils.isEmpty((CharSequence)qualifiedName)) {
            return Optional.empty();
        }
        DataEngineSchemaTypeHandler handler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "getSchemaTypeGUID");
        Optional<EntityDetail> schemaType = handler.findSchemaTypeEntity(userId, qualifiedName);
        return schemaType.map(InstanceHeader::getGUID);
    }

    public GUIDResponse upsertSchemaType(String userId, String serverName, SchemaTypeRequestBody schemaTypeRequestBody) {
        String methodName = "upsertSchemaType";
        GUIDResponse response = new GUIDResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)schemaTypeRequestBody, "upsertSchemaType")) {
                return response;
            }
            String externalSourceName = schemaTypeRequestBody.getExternalSourceName();
            String schemasTypeGUID = this.upsertSchemaType(userId, serverName, null, schemaTypeRequestBody.getSchemaType(), externalSourceName);
            response.setGUID(schemasTypeGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertSchemaType");
        }
        return response;
    }

    public VoidResponse deleteSchemaType(String userId, String serverName, DeleteRequestBody requestBody) {
        String methodName = "deleteSchemaType";
        VoidResponse response = new VoidResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deleteSchemaType")) {
                return response;
            }
            this.deleteSchemaType(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteSchemaType");
        }
        return response;
    }

    public void deleteSchemaType(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        String methodName = "deleteSchemaType";
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteSchemaType");
        Optional<String> schemaTypeGUIDOptional = Optional.ofNullable(guid);
        if (!schemaTypeGUIDOptional.isPresent()) {
            schemaTypeGUIDOptional = this.getSchemaTypeGUID(serverName, userId, qualifiedName);
        }
        if (!schemaTypeGUIDOptional.isPresent()) {
            this.throwEntityNotDeletedException(userId, serverName, "deleteSchemaType", qualifiedName);
        }
        String schemaTypeGUID = schemaTypeGUIDOptional.get();
        dataEngineSchemaTypeHandler.removeSchemaType(userId, schemaTypeGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)schemaTypeGUID);
    }

    public GUIDResponse upsertPortImplementation(String userId, String serverName, PortImplementationRequestBody portImplementationRequestBody) {
        String methodName = "upsertPortImplementation";
        GUIDResponse response = new GUIDResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)portImplementationRequestBody, "upsertPortImplementation")) {
                return response;
            }
            String processGUID = this.getProcessGUID(serverName, userId, portImplementationRequestBody.getProcessQualifiedName()).orElse(null);
            String externalSourceName = portImplementationRequestBody.getExternalSourceName();
            PortImplementation portImplementation = portImplementationRequestBody.getPortImplementation();
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            String portImplementationGUID = this.upsertPortImplementation(userId, serverName, portImplementation, processGUID, externalSourceName);
            response.setGUID(portImplementationGUID);
            this.upsertSchemaType(userId, serverName, portImplementationGUID, portImplementation.getSchemaType(), externalSourceName);
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertPortImplementation");
        }
        return response;
    }

    public GUIDResponse upsertPortAlias(String userId, String serverName, PortAliasRequestBody portAliasRequestBody) {
        String methodName = "upsertPortAliasWithDelegation";
        GUIDResponse response = new GUIDResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)portAliasRequestBody, "upsertPortAliasWithDelegation")) {
                return response;
            }
            String processGUID = this.getProcessGUID(serverName, userId, portAliasRequestBody.getProcessQualifiedName()).orElse(null);
            String externalSourceName = portAliasRequestBody.getExternalSourceName();
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.DRAFT, externalSourceName);
            response.setGUID(this.upsertPortAliasWithDelegation(userId, serverName, portAliasRequestBody.getPortAlias(), processGUID, externalSourceName));
            this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertPortAliasWithDelegation");
        }
        return response;
    }

    public VoidResponse deletePort(String userId, String serverName, DeleteRequestBody requestBody, String portType) {
        String methodName = "deletePort";
        VoidResponse response = new VoidResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, "deletePort")) {
                return response;
            }
            this.deletePort(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuid(), requestBody.getQualifiedName(), portType, requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deletePort");
        }
        return response;
    }

    public void deletePort(String userId, String serverName, String externalSourceName, String guid, String qualifiedName, String portType, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        Optional<EntityDetail> schemaType;
        String methodName = "deletePort";
        Optional<String> portGUIDOptional = Optional.ofNullable(guid);
        if (!portGUIDOptional.isPresent()) {
            portGUIDOptional = this.getPortGUID(serverName, userId, qualifiedName);
        }
        if (!portGUIDOptional.isPresent()) {
            this.throwEntityNotDeletedException(userId, serverName, "deletePort", qualifiedName);
        }
        String portGUID = portGUIDOptional.get();
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "deletePort");
        if ("PortImplementation".equalsIgnoreCase(portType) && (schemaType = dataEnginePortHandler.findSchemaTypeForPort(userId, portGUID)).isPresent()) {
            this.deleteSchemaType(userId, serverName, externalSourceName, schemaType.get().getGUID(), null, deleteSemantic);
        }
        dataEnginePortHandler.removePort(userId, portGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)guid);
    }

    public GUIDResponse addProcessHierarchy(String userId, String serverName, ProcessHierarchyRequestBody processHierarchyRequestBody) {
        String methodName = "addProcessHierarchy";
        GUIDResponse response = new GUIDResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)processHierarchyRequestBody, "addProcessHierarchy")) {
                return response;
            }
            response.setGUID(this.addProcessHierarchyToProcess(userId, serverName, processHierarchyRequestBody.getProcessHierarchy(), processHierarchyRequestBody.getExternalSourceName()));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addProcessHierarchy");
        }
        return response;
    }

    public ProcessListResponse upsertProcesses(String userId, String serverName, ProcessesRequestBody processesRequestBody) {
        String methodName = "upsertProcesses";
        ProcessListResponse response = new ProcessListResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)processesRequestBody, "upsertProcesses")) {
                return response;
            }
            if (CollectionUtils.isEmpty((Collection)processesRequestBody.getProcesses())) {
                this.restExceptionHandler.handleMissingValue("processes", "upsertProcesses");
                return response;
            }
            return this.upsertProcesses(userId, serverName, processesRequestBody.getProcesses(), processesRequestBody.getExternalSourceName());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertProcesses");
            return response;
        }
    }

    public VoidResponse deleteProcesses(String userId, String serverName, ProcessesDeleteRequestBody requestBody) {
        String methodName = "deleteProcesses";
        VoidResponse response = new VoidResponse();
        try {
            if (!this.isDeleteProcessesRequestBodyValid(userId, serverName, requestBody, "deleteProcesses")) {
                return response;
            }
            this.deleteProcesses(userId, serverName, requestBody.getExternalSourceName(), requestBody.getGuids(), requestBody.getQualifiedNames(), requestBody.getDeleteSemantic());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteProcesses");
        }
        return response;
    }

    public void deleteProcesses(String userId, String serverName, String externalSourceName, List<String> guids, List<String> qualifiedNames, DeleteSemantic deleteSemantic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException, EntityNotDeletedException {
        String methodName = "deleteProcesses";
        if (CollectionUtils.isNotEmpty(qualifiedNames)) {
            for (String qualifiedName : qualifiedNames) {
                Optional<String> processGUIDOptional = this.getProcessGUID(serverName, userId, qualifiedName);
                if (!processGUIDOptional.isPresent()) {
                    this.throwEntityNotDeletedException(userId, serverName, "deleteProcesses", qualifiedName);
                }
                this.deleteProcess(userId, serverName, externalSourceName, processGUIDOptional.get(), deleteSemantic);
            }
        }
        if (CollectionUtils.isNotEmpty(guids)) {
            for (String guid : guids) {
                this.deleteProcess(userId, serverName, externalSourceName, guid, deleteSemantic);
            }
        }
    }

    private void deleteProcess(String userId, String serverName, String externalSourceName, String processGUID, DeleteSemantic deleteSemantic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException, EntityNotDeletedException {
        String methodName = "deleteProcess";
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteProcess");
        Set<EntityDetail> portImplementations = processHandler.getPortsForProcess(userId, processGUID, "PortImplementation");
        for (EntityDetail port : portImplementations) {
            this.deletePort(userId, serverName, externalSourceName, port.getGUID(), null, "PortImplementation", deleteSemantic);
        }
        Set<EntityDetail> portAliases = processHandler.getPortsForProcess(userId, processGUID, "PortAlias");
        for (EntityDetail port : portAliases) {
            this.deletePort(userId, serverName, externalSourceName, port.getGUID(), null, "PortAlias", deleteSemantic);
        }
        processHandler.removeProcess(userId, processGUID, externalSourceName, deleteSemantic);
        log.debug(DEBUG_DELETE_MESSAGE, (Object)processGUID);
    }

    public String upsertPortAliasWithDelegation(String userId, String serverName, PortAlias portAlias, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portAliasGUID;
        String methodName = "upsertPortAliasWithDelegation";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortAliasWithDelegation", (Object)portAlias);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortAliasWithDelegation");
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortAliasEntity(userId, portAlias.getQualifiedName());
        if (!portEntity.isPresent()) {
            portAliasGUID = dataEnginePortHandler.createPortAlias(userId, portAlias, processGUID, externalSourceName);
        } else {
            portAliasGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortAlias(userId, portEntity.get(), portAlias, externalSourceName);
        }
        if (!StringUtils.isEmpty((CharSequence)portAlias.getDelegatesTo())) {
            dataEnginePortHandler.addPortDelegationRelationship(userId, portAliasGUID, portAlias.getPortType(), portAlias.getDelegatesTo(), externalSourceName);
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortAliasWithDelegation", (Object)portAliasGUID);
        return portAliasGUID;
    }

    public String addProcessHierarchyToProcess(String userId, String serverName, ProcessHierarchy processHierarchy, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessHierarchyToProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addProcessHierarchyToProcess", (Object)processHierarchy);
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyToProcess");
        Optional<EntityDetail> childProcessEntity = processHandler.findProcessEntity(userId, processHierarchy.getChildProcess());
        if (!childProcessEntity.isPresent()) {
            throw new InvalidParameterException(DataEngineErrorCode.PROCESS_NOT_FOUND.getMessageDefinition(new String[]{processHierarchy.getChildProcess()}), this.getClass().getName(), "addProcessHierarchyToProcess", "childProcess");
        }
        String childProcessGUID = childProcessEntity.get().getGUID();
        ParentProcess parentProcess = new ParentProcess();
        parentProcess.setQualifiedName(processHierarchy.getParentProcess());
        parentProcess.setProcessContainmentType(processHierarchy.getProcessContainmentType());
        processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, childProcessGUID, externalSourceName);
        log.info("Data Engine OMAS has added a relationship of type ProcessHierarchy between child process {} and parent process {}", (Object)processHierarchy.getChildProcess(), (Object)processHierarchy.getParentProcess());
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addProcessHierarchyToProcess", (Object)childProcessGUID);
        return childProcessGUID;
    }

    public String upsertPortImplementation(String userId, String serverName, PortImplementation portImplementation, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, FunctionNotSupportedException {
        String portImplementationGUID;
        String methodName = "upsertPortImplementation";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortImplementation", (Object)portImplementation);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortImplementation");
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortImplementationEntity(userId, portImplementation.getQualifiedName());
        if (!portEntity.isPresent()) {
            portImplementationGUID = dataEnginePortHandler.createPortImplementation(userId, portImplementation, processGUID, externalSourceName);
        } else {
            Optional<EntityDetail> schemaTypeForPort;
            portImplementationGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortImplementation(userId, portEntity.get(), portImplementation, externalSourceName);
            if (portImplementation.getUpdateSemantic() == UpdateSemantic.REPLACE && (schemaTypeForPort = dataEnginePortHandler.findSchemaTypeForPort(userId, portImplementationGUID)).isPresent()) {
                String oldSchemaTypeQualifiedName = schemaTypeForPort.get().getProperties().getPropertyValue("qualifiedName").valueAsString();
                this.deleteObsoleteSchemaType(userId, serverName, portImplementation.getSchemaType().getQualifiedName(), oldSchemaTypeQualifiedName, externalSourceName);
            }
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortImplementation", (Object)portImplementationGUID);
        return portImplementationGUID;
    }

    public String createExternalDataEngine(String userId, String serverName, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createExternalDataEngine";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"createExternalDataEngine", (Object)softwareServerCapability);
        if (softwareServerCapability == null) {
            return null;
        }
        DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataEngine");
        String softwareServerCapabilityGUID = handler.upsertExternalDataEngine(userId, softwareServerCapability);
        log.info("Data Engine OMAS has registered an external engine with qualified name {} and GUID {}", (Object)softwareServerCapability.getQualifiedName(), (Object)softwareServerCapabilityGUID);
        return softwareServerCapabilityGUID;
    }

    public void addLineageMappings(String userId, String serverName, List<LineageMapping> lineageMappings, FFDCResponseBase response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLineageMappings";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addLineageMappings", lineageMappings);
        if (CollectionUtils.isEmpty(lineageMappings)) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addLineageMappings");
        lineageMappings.parallelStream().forEach(lineageMapping -> {
            try {
                dataEngineSchemaTypeHandler.addLineageMappingRelationship(userId, lineageMapping.getSourceAttribute(), lineageMapping.getTargetAttribute(), externalSourceName);
            }
            catch (Exception error) {
                log.error(EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING, (Object)lineageMapping.toString(), (Object)error.toString());
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addLineageMappings");
            }
        });
    }

    public ProcessListResponse upsertProcesses(String userId, String serverName, List<Process> processes, String externalSourceName) {
        String methodName = "upsertProcesses";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertProcesses", processes);
        Predicate<Process> hasPortImplementationsPredicate = process -> CollectionUtils.isNotEmpty((Collection)process.getPortImplementations());
        Map<Boolean, List<Process>> partitionedProcesses = processes.parallelStream().collect(Collectors.partitioningBy(hasPortImplementationsPredicate));
        ArrayList createdProcesses = new ArrayList();
        ArrayList<GUIDResponse> failedProcesses = new ArrayList<GUIDResponse>();
        Consumer<Process> processConsumer = process -> {
            GUIDResponse guidResponse = this.upsertProcess(userId, serverName, (Process)process, externalSourceName);
            if (guidResponse.getRelatedHTTPCode() == HttpStatus.OK.value()) {
                String processGUID = guidResponse.getGUID();
                process.setGUID(processGUID);
                VoidResponse updateStatusResponse = this.updateProcessStatus(userId, serverName, processGUID, InstanceStatus.ACTIVE, externalSourceName);
                if (updateStatusResponse.getRelatedHTTPCode() != 200) {
                    this.captureException((FFDCResponseBase)updateStatusResponse, (FFDCResponseBase)guidResponse);
                }
                createdProcesses.add(guidResponse);
            } else {
                failedProcesses.add(guidResponse);
            }
        };
        partitionedProcesses.get(Boolean.TRUE).parallelStream().forEach(processConsumer);
        partitionedProcesses.get(Boolean.FALSE).forEach(processConsumer);
        ProcessListResponse response = new ProcessListResponse();
        response.setGUIDs(createdProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        this.handleFailedProcesses(response, failedProcesses);
        this.addProcessHierarchyRelationships(userId, serverName, processes, response, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertProcesses", (Object)response);
        return response;
    }

    public VoidResponse addLineageMappings(String userId, String serverName, LineageMappingsRequestBody lineageMappingsRequestBody) {
        String methodName = "addLineageMappings";
        VoidResponse response = new VoidResponse();
        try {
            if (lineageMappingsRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLineageMappings", serverName);
                return response;
            }
            this.addLineageMappings(userId, serverName, lineageMappingsRequestBody.getLineageMappings(), (FFDCResponseBase)response, lineageMappingsRequestBody.getExternalSourceName());
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addLineageMappings");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addLineageMappings", (Object)response);
        return response;
    }

    public ConnectionResponse getInTopicConnection(String serverName, String userId) {
        String methodName = "getInTopicConnection";
        ConnectionResponse response = new ConnectionResponse();
        try {
            response.setConnection(this.instanceHandler.getInTopicConnection(userId, serverName, "getInTopicConnection"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "getInTopicConnection");
        }
        return response;
    }

    public String upsertSchemaType(String userId, String serverName, String portImplementationGUID, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertSchemaType", (Object)schemaType);
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "upsertSchemaType");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertSchemaType");
        String schemaTypeGUID = dataEngineSchemaTypeHandler.upsertSchemaType(userId, schemaType, externalSourceName);
        if (StringUtils.isNotEmpty((CharSequence)portImplementationGUID)) {
            dataEnginePortHandler.addPortSchemaRelationship(userId, portImplementationGUID, schemaTypeGUID, "upsertSchemaType");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertSchemaType", (Object)schemaTypeGUID);
        return schemaTypeGUID;
    }

    public GUIDResponse upsertDatabase(String userId, String serverName, DatabaseRequestBody databaseRequestBody) {
        String methodName = "upsertDatabase";
        GUIDResponse response = new GUIDResponse();
        try {
            if (!this.isDatabaseRequestBodyValid(userId, serverName, databaseRequestBody, "upsertDatabase")) {
                return response;
            }
            Database database = databaseRequestBody.getDatabase();
            log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertDatabase", (Object)database);
            DataEngineRelationalDataHandler dataEngineRelationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "upsertDatabase");
            String databaseGUID = dataEngineRelationalDataHandler.upsertDatabase(userId, database, databaseRequestBody.getExternalSourceName());
            log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertDatabase", (Object)databaseGUID);
            response.setGUID(databaseGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertDatabase");
        }
        return response;
    }

    public GUIDResponse upsertRelationalTable(String userId, String serverName, RelationalTableRequestBody relationalTableRequestBody) {
        String methodName = "upsertRelationalTable";
        GUIDResponse response = new GUIDResponse();
        try {
            if (!this.isRelationalTableRequestBodyValid(userId, serverName, relationalTableRequestBody, "upsertRelationalTable")) {
                return response;
            }
            RelationalTable relationalTable = relationalTableRequestBody.getRelationalTable();
            log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertRelationalTable", (Object)relationalTable);
            DataEngineRelationalDataHandler dataEngineRelationalDataHandler = this.instanceHandler.getRelationalDataHandler(userId, serverName, "upsertRelationalTable");
            String relationalTableGUID = dataEngineRelationalDataHandler.upsertRelationalTable(userId, relationalTableRequestBody.getDatabaseQualifiedName(), relationalTable, relationalTableRequestBody.getExternalSourceName());
            log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertRelationalTable", (Object)relationalTableGUID);
            response.setGUID(relationalTableGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertRelationalTable");
        }
        return response;
    }

    private void deleteObsoleteSchemaType(String userId, String serverName, String schemaTypeQualifiedName, String oldSchemaTypeQualifiedName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, FunctionNotSupportedException {
        String methodName = "deleteObsoleteSchemaType";
        if (oldSchemaTypeQualifiedName.equalsIgnoreCase(schemaTypeQualifiedName)) {
            return;
        }
        Optional<String> schemaTypeGUID = this.getSchemaTypeGUID(serverName, userId, oldSchemaTypeQualifiedName);
        if (!schemaTypeGUID.isPresent()) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteObsoleteSchemaType");
        dataEngineSchemaTypeHandler.removeSchemaType(userId, schemaTypeGUID.get(), externalSourceName, DeleteSemantic.HARD);
    }

    private void handleFailedProcesses(ProcessListResponse response, List<GUIDResponse> failedProcesses) {
        response.setFailedGUIDs(failedProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        failedProcesses.parallelStream().forEach(guidResponse -> this.captureException((FFDCResponseBase)guidResponse, (FFDCResponseBase)response));
    }

    private void captureException(FFDCResponseBase initialResponse, FFDCResponseBase response) {
        response.setExceptionErrorMessage(initialResponse.getExceptionErrorMessage());
        response.setExceptionClassName(initialResponse.getExceptionClassName());
        response.setExceptionSystemAction(initialResponse.getExceptionSystemAction());
        response.setExceptionUserAction(initialResponse.getExceptionUserAction());
        response.setRelatedHTTPCode(initialResponse.getRelatedHTTPCode());
        response.setExceptionProperties(initialResponse.getExceptionProperties());
    }

    private VoidResponse updateProcessStatus(String userId, String serverName, String processGUID, InstanceStatus instanceStatus, String externalSourceName) {
        String methodName = "updateProcessStatus";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"updateProcessStatus", (Object)processGUID);
        VoidResponse response = new VoidResponse();
        try {
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "updateProcessStatus");
            processHandler.updateProcessStatus(userId, processGUID, instanceStatus, externalSourceName);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "updateProcessStatus");
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"updateProcessStatus", (Object)response);
        return response;
    }

    private GUIDResponse upsertProcess(String userId, String serverName, Process process, String externalSourceName) {
        String methodName = "upsertProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertProcess", (Object)process);
        String qualifiedName = process.getQualifiedName();
        List portImplementations = process.getPortImplementations();
        List portAliases = process.getPortAliases();
        List lineageMappings = process.getLineageMappings();
        UpdateSemantic updateSemantic = process.getUpdateSemantic();
        GUIDResponse response = new GUIDResponse();
        try {
            String processGUID;
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "upsertProcess");
            Optional<EntityDetail> processEntity = processHandler.findProcessEntity(userId, qualifiedName);
            if (!processEntity.isPresent()) {
                processGUID = processHandler.createProcess(userId, process, externalSourceName);
            } else {
                processGUID = processEntity.get().getGUID();
                processHandler.updateProcess(userId, processEntity.get(), process, externalSourceName);
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.DRAFT, externalSourceName);
                if (updateSemantic == UpdateSemantic.REPLACE) {
                    this.deleteObsoletePorts(userId, serverName, portImplementations, processGUID, "PortImplementation", response, externalSourceName);
                    this.deleteObsoletePorts(userId, serverName, portAliases, processGUID, "PortAlias", response, externalSourceName);
                }
            }
            String collectionGUID = this.createCollection(userId, serverName, process.getCollection(), externalSourceName);
            if (collectionGUID != null) {
                this.addProcessCollectionRelationship(userId, serverName, processGUID, collectionGUID, externalSourceName);
            }
            this.upsertPortImplementations(userId, serverName, portImplementations, processGUID, response, externalSourceName);
            this.upsertPortAliases(userId, serverName, portAliases, processGUID, response, externalSourceName);
            this.addLineageMappings(userId, serverName, lineageMappings, (FFDCResponseBase)response, externalSourceName);
            log.info("Data Engine OMAS has created or updated a Process with qualified name {} and guid {}", (Object)qualifiedName, (Object)processGUID);
            response.setGUID(processGUID);
        }
        catch (Exception error) {
            log.error(EXCEPTION_WHILE_CREATING_PROCESS, (Object)qualifiedName, (Object)error.toString());
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertProcess");
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertProcess", (Object)response);
        return response;
    }

    private String createCollection(String userId, String serverName, org.odpi.openmetadata.accessservices.dataengine.model.Collection collection, String externalSourceName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "createCollection";
        DataEngineCollectionHandler dataEngineCollectionHandler = this.instanceHandler.getCollectionHandler(userId, serverName, "createCollection");
        if (collection == null) {
            return null;
        }
        String collectionQualifiedName = collection.getQualifiedName();
        Optional<EntityDetail> collectionEntity = dataEngineCollectionHandler.findCollectionEntity(userId, collectionQualifiedName);
        String collectionGUID = !collectionEntity.isPresent() ? dataEngineCollectionHandler.createCollection(userId, collection, externalSourceName) : collectionEntity.get().getGUID();
        return collectionGUID;
    }

    private void addProcessHierarchyRelationships(String userId, String serverName, List<Process> processes, ProcessListResponse response, String externalSourceName) {
        String methodName = "addProcessHierarchyRelationships";
        processes.parallelStream().filter(process -> response.getGUIDs().contains(process.getGUID())).forEach(process -> {
            List parentProcesses = process.getParentProcesses();
            String processGUID = process.getGUID();
            if (CollectionUtils.isNotEmpty((Collection)parentProcesses)) {
                try {
                    DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyRelationships");
                    for (ParentProcess parentProcess : parentProcesses) {
                        processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, processGUID, externalSourceName);
                    }
                }
                catch (Exception error) {
                    log.error(EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY, (Object)process.getQualifiedName(), (Object)error.toString());
                    this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "addProcessHierarchyRelationships");
                }
            }
        });
    }

    private void addProcessCollectionRelationship(String userId, String serverName, String processGUID, String collectionGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessCollectionRelationship";
        DataEngineCollectionHandler dataEngineCollectionHandler = this.instanceHandler.getCollectionHandler(userId, serverName, "addProcessCollectionRelationship");
        dataEngineCollectionHandler.addCollectionMembershipRelationship(userId, collectionGUID, processGUID, externalSourceName);
    }

    private void deleteObsoletePorts(String userId, String serverName, List<? extends Port> ports, String processGUID, String portTypeName, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteObsoletePorts";
        if (CollectionUtils.isEmpty(ports)) {
            return;
        }
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteObsoletePorts");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "deleteObsoletePorts");
        Set<EntityDetail> existingPorts = processHandler.getPortsForProcess(userId, processGUID, portTypeName);
        Set portQualifiedNames = existingPorts.stream().map(entityDetail -> entityDetail.getProperties().getPropertyValue("qualifiedName").valueAsString()).collect(Collectors.toSet());
        Set newPortQualifiedNames = ports.stream().map(Referenceable::getQualifiedName).collect(Collectors.toSet());
        List<String> obsoletePortQualifiedNames = portQualifiedNames.stream().collect(Collectors.partitioningBy(newPortQualifiedNames::contains)).get(Boolean.FALSE);
        obsoletePortQualifiedNames.forEach(portQualifiedName -> {
            try {
                Optional<String> portGUID = this.getPortGUID(serverName, userId, (String)portQualifiedName);
                if (portGUID.isPresent()) {
                    dataEnginePortHandler.removePort(userId, portGUID.get(), externalSourceName, DeleteSemantic.HARD);
                }
            }
            catch (Exception error) {
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "deleteObsoletePorts");
            }
        });
    }

    private void upsertPortImplementations(String userId, String serverName, List<PortImplementation> portImplementations, String processGUID, GUIDResponse response, String externalSourceName) {
        String methodName = "upsertPortImplementations";
        if (CollectionUtils.isEmpty(portImplementations)) {
            return;
        }
        HashMap<String, SchemaType> schemaTypeMap = new HashMap<String, SchemaType>();
        try {
            for (PortImplementation portImplementation : portImplementations) {
                String portGUID2 = this.upsertPortImplementation(userId, serverName, portImplementation, processGUID, externalSourceName);
                schemaTypeMap.put(portGUID2, portImplementation.getSchemaType());
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertPortImplementations");
        }
        schemaTypeMap.keySet().parallelStream().forEach(portGUID -> {
            try {
                this.upsertSchemaType(userId, serverName, (String)portGUID, (SchemaType)schemaTypeMap.get(portGUID), externalSourceName);
            }
            catch (Exception error) {
                this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertPortImplementations");
            }
        });
    }

    private void upsertPortAliases(String userId, String serverName, List<PortAlias> portAliases, String processGUID, GUIDResponse response, String externalSourceName) {
        String methodName = "upsertPortAliases";
        if (CollectionUtils.isNotEmpty(portAliases)) {
            portAliases.forEach(portAlias -> {
                try {
                    this.upsertPortAliasWithDelegation(userId, serverName, (PortAlias)portAlias, processGUID, externalSourceName);
                }
                catch (Exception error) {
                    this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, "upsertPortAliases");
                }
            });
        }
    }

    private boolean isDatabaseRequestBodyValid(String userId, String serverName, DatabaseRequestBody databaseRequestBody, String methodName) throws InvalidParameterException {
        if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)databaseRequestBody, methodName)) {
            return false;
        }
        if (databaseRequestBody.getDatabase() == null) {
            this.restExceptionHandler.handleMissingValue("database", methodName);
            return false;
        }
        return true;
    }

    private boolean isRelationalTableRequestBodyValid(String userId, String serverName, RelationalTableRequestBody relationalTableRequestBody, String methodName) throws InvalidParameterException {
        if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)relationalTableRequestBody, methodName)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)relationalTableRequestBody.getDatabaseQualifiedName())) {
            this.restExceptionHandler.handleMissingValue("databaseQualifiedName", methodName);
            return false;
        }
        return true;
    }

    private boolean isRequestBodyInvalid(String userId, String serverName, DataEngineOMASAPIRequestBody requestBody, String methodName) throws InvalidParameterException {
        if (requestBody == null) {
            this.restExceptionHandler.handleNoRequestBody(userId, methodName, serverName);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)requestBody.getExternalSourceName())) {
            this.restExceptionHandler.handleMissingValue("externalSourceName", methodName);
            return true;
        }
        return false;
    }

    private boolean isDeleteProcessesRequestBodyValid(String userId, String serverName, ProcessesDeleteRequestBody requestBody, String methodName) throws InvalidParameterException {
        if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)requestBody, methodName)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)requestBody.getQualifiedNames()) && CollectionUtils.isEmpty((Collection)requestBody.getGuids())) {
            this.restExceptionHandler.handleMissingValue("qualifiedNames", methodName);
            return false;
        }
        return true;
    }

    public GUIDResponse upsertDataFile(String serverName, String userId, DataFileRequestBody dataFileRequestBody) {
        String methodName = "createDataFileAndSchema";
        GUIDResponse response = new GUIDResponse();
        try {
            if (this.isRequestBodyInvalid(userId, serverName, (DataEngineOMASAPIRequestBody)dataFileRequestBody, methodName)) {
                return response;
            }
            DataEngineDataFileHandler dataFileHandler = this.instanceHandler.getDataFileHandler(userId, serverName, methodName);
            DataEngineRegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(userId, serverName, methodName);
            String externalSourceName = dataFileRequestBody.getExternalSourceName();
            String externalSourceGuid = registrationHandler.getExternalDataEngine(userId, externalSourceName);
            DataFile file = dataFileRequestBody.getDataFile();
            List columns = file.getColumns();
            SchemaType schemaType = this.getDefaultSchemaTypeIfAbsentAndAddAttributes(file, file.getSchema(), columns);
            HashMap<String, Object> extendedProperties = this.getExtendedProperties(file);
            String fileTypeGuid = file instanceof CSVFile ? "2ccb2117-9cee-47ca-8150-9b3a543adcec" : "10752b4a-4b5d-4519-9eae-fdd6d162122f";
            String fileTypeName = file instanceof CSVFile ? "CSVFile" : "DataFile";
            file.setFileType(fileTypeName);
            String guid = dataFileHandler.upsertFileAssetIntoCatalog(fileTypeName, fileTypeGuid, file, schemaType, columns, extendedProperties, externalSourceGuid, externalSourceName, userId, methodName);
            response.setGUID(guid);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, (Throwable)error, methodName);
        }
        return response;
    }

    private SchemaType getDefaultSchemaTypeIfAbsentAndAddAttributes(DataFile file, SchemaType schemaType, List<Attribute> attributes) {
        if (schemaType == null) {
            schemaType = new SchemaType();
            schemaType.setQualifiedName(file.getQualifiedName() + "::schema");
            schemaType.setDisplayName("Schema");
        }
        schemaType.setAttributeList(attributes);
        return schemaType;
    }

    private HashMap<String, Object> getExtendedProperties(DataFile file) {
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        if (file instanceof CSVFile) {
            CSVFile csvFile = (CSVFile)file;
            extendedProperties.put("fileType", csvFile.getFileType());
            extendedProperties.put("delimiterCharacter", csvFile.getDelimiterCharacter());
            extendedProperties.put("quoteCharacter", csvFile.getQuoteCharacter());
        } else {
            extendedProperties.put("fileType", file.getFileType());
        }
        return extendedProperties;
    }

    private void throwEntityNotDeletedException(String userId, String serverName, String methodName, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, EntityNotDeletedException {
        DataEngineCommonHandler dataEngineCommonHandler = this.instanceHandler.getCommonHandler(userId, serverName, methodName);
        dataEngineCommonHandler.throwEntityNotDeletedException(DataEngineErrorCode.ENTITY_NOT_DELETED, methodName, qualifiedName);
    }
}

