/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ExternalDataEnginePropertiesBuilder
extends ReferenceableBuilder {
    private final String name;
    private final String description;
    private final String type;
    private final String version;
    private final String source;
    private final String patchLevel;

    public ExternalDataEnginePropertiesBuilder(String qualifiedName, String name, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, repositoryHelper, serviceName, serverName);
        this.name = name;
        this.description = description;
        this.type = type;
        this.version = version;
        this.patchLevel = patchLevel;
        this.source = source;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.name != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.name, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.type != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "type", this.type, methodName);
        }
        if (this.version != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "version", this.version, methodName);
        }
        if (this.patchLevel != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "patchLevel", this.patchLevel, methodName);
        }
        if (this.source != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", this.source, methodName);
        }
        return properties;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.name != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.name);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", literalName, methodName);
        }
        return properties;
    }
}

