/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.AssetBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessPropertiesBuilder
extends AssetBuilder {
    private final String processDisplayName;
    private final String formula;

    public ProcessPropertiesBuilder(String qualifiedName, String displayName, String processDisplayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, String latestChange, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, displayName, description, owner, ownerType, zoneMembership, null, latestChange, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.processDisplayName = processDisplayName;
        this.formula = formula;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.processDisplayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.processDisplayName, methodName);
        }
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        return properties;
    }
}

