/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.RelationshipDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineCommonHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private static final Logger log = LoggerFactory.getLogger(DataEngineCommonHandler.class);

    public DataEngineCommonHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataEngineRegistrationHandler dataEngineRegistrationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.dataEngineRegistrationHandler = dataEngineRegistrationHandler;
    }

    protected String createExternalEntity(String userId, InstanceProperties instanceProperties, InstanceStatus instanceStatus, String entityTypeName, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalEntity";
        String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        return this.repositoryHandler.createExternalEntity(userId, entityTypeDef.getGUID(), entityTypeDef.getName(), externalSourceGUID, externalSourceName, instanceProperties, instanceStatus, "createExternalEntity");
    }

    protected void updateEntity(String userId, String entityGUID, InstanceProperties instanceProperties, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEntity";
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        this.repositoryHandler.updateEntity(userId, entityGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), instanceProperties, "updateEntity");
    }

    protected EntityDetail buildEntityDetail(String entityGUID, InstanceProperties instanceProperties) {
        EntityDetail entityDetail = new EntityDetail();
        entityDetail.setGUID(entityGUID);
        entityDetail.setProperties(instanceProperties);
        return entityDetail;
    }

    protected Relationship buildRelationship(String entityGUID, InstanceProperties instanceProperties) {
        Relationship relationship = new Relationship();
        relationship.setGUID(entityGUID);
        relationship.setProperties(instanceProperties);
        return relationship;
    }

    protected Optional<EntityDetail> findEntity(String userId, String qualifiedName, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        String methodName = "findEntity";
        this.invalidParameterHandler.validateUserId(userId, "findEntity");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "findEntity");
        qualifiedName = this.repositoryHelper.getExactMatchRegex(qualifiedName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", qualifiedName, "findEntity");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        Optional<EntityDetail> retrievedEntity = Optional.ofNullable(this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", properties, entityTypeDef.getGUID(), entityTypeDef.getName(), "findEntity"));
        log.debug("Searching for entity with qualifiedName: {}. Result is {}", (Object)qualifiedName, retrievedEntity.map(InstanceHeader::getGUID).orElse(null));
        return retrievedEntity;
    }

    protected void createOrUpdateExternalRelationship(String userId, String firstGUID, String secondGUID, String relationshipTypeName, String firstEntityTypeName, String externalSourceName, InstanceProperties relationshipProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createOrUpdateExternalRelationship";
        this.invalidParameterHandler.validateUserId(userId, "createOrUpdateExternalRelationship");
        this.invalidParameterHandler.validateGUID(firstGUID, "guid", "createOrUpdateExternalRelationship");
        this.invalidParameterHandler.validateGUID(secondGUID, "guid", "createOrUpdateExternalRelationship");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, relationshipTypeName);
        Optional<Relationship> relationship = Optional.ofNullable(this.repositoryHandler.getRelationshipBetweenEntities(userId, firstGUID, firstEntityTypeName, secondGUID, relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), "createOrUpdateExternalRelationship"));
        if (!relationship.isPresent()) {
            String externalSourceGUID = this.dataEngineRegistrationHandler.getExternalDataEngineByQualifiedName(userId, externalSourceName);
            this.repositoryHandler.createExternalRelationship(userId, relationshipTypeDef.getGUID(), externalSourceGUID, externalSourceName, firstGUID, secondGUID, relationshipProperties, "createOrUpdateExternalRelationship");
        } else {
            Relationship originalRelationship = relationship.get();
            RelationshipDifferences relationshipDifferences = this.repositoryHelper.getRelationshipDifferences(originalRelationship, this.buildRelationship(originalRelationship.getGUID(), relationshipProperties), true);
            if (relationshipDifferences.hasInstancePropertiesDifferences()) {
                this.repositoryHandler.updateRelationshipProperties(userId, originalRelationship.getGUID(), relationshipProperties, "createOrUpdateExternalRelationship");
            }
        }
    }

    protected void removeEntity(String userId, String entityGUID, String entityTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeEntity";
        this.invalidParameterHandler.validateUserId(userId, "removeEntity");
        this.invalidParameterHandler.validateGUID(entityGUID, "guid", "removeEntity");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, entityTypeName);
        this.repositoryHandler.removeEntity(userId, entityGUID, entityTypeDef.getGUID(), entityTypeDef.getName(), null, null, "removeEntity");
    }

    protected void throwInvalidParameterException(DataEngineErrorCode errorCode, String methodName, String parameterName, String ... params) throws InvalidParameterException {
        throw new InvalidParameterException(errorCode.getMessageDefinition(params), this.getClass().getName(), methodName, parameterName);
    }
}

