/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.PortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.ProcessHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineServicesInstance
extends OCFOMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.DATA_ENGINE_OMAS;
    private ProcessHandler processHandler;
    private DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private PortHandler portHandler;
    private Connection inTopicConnection;

    DataEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection inTopicConnection) throws NewInstanceException {
        super(description.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, auditLog, localServerUserId, maxPageSize);
        this.inTopicConnection = inTopicConnection;
        if (this.repositoryHandler != null) {
            this.dataEngineRegistrationHandler = new DataEngineRegistrationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
            DataEngineCommonHandler dataEngineCommonHandler = new DataEngineCommonHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataEngineRegistrationHandler);
            this.processHandler = new ProcessHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.assetHandler, dataEngineCommonHandler, defaultZones, supportedZones);
            this.dataEngineSchemaTypeHandler = new DataEngineSchemaTypeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.schemaTypeHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
            this.portHandler = new PortHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, dataEngineCommonHandler);
            if (this.securityVerifier != null) {
                this.processHandler.setSecurityVerifier(this.securityVerifier);
            }
        } else {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(DataEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
    }

    ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    DataEngineRegistrationHandler getDataEngineRegistrationHandler() {
        return this.dataEngineRegistrationHandler;
    }

    DataEngineSchemaTypeHandler getDataEngineSchemaTypeHandler() {
        return this.dataEngineSchemaTypeHandler;
    }

    PortHandler getPortHandler() {
        return this.portHandler;
    }

    Connection getInTopicConnection() {
        return this.inTopicConnection;
    }
}

