/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.handlers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.dataengine.server.builders.ProcessPropertiesBuilder;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.springframework.util.StringUtils;

public class ProcessHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final AssetHandler assetHandler;
    private final DataEngineCommonHandler dataEngineCommonHandler;
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    private List<String> supportedZones;
    private List<String> defaultZones;

    public ProcessHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, AssetHandler assetHandler, DataEngineCommonHandler dataEngineCommonHandler, List<String> defaultZones, List<String> supportedZones) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.assetHandler = assetHandler;
        this.dataEngineCommonHandler = dataEngineCommonHandler;
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        this.securityVerifier = securityVerifier;
    }

    public String createProcess(String userId, Process process, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        this.initializeAssetZoneMembership(process);
        this.securityVerifier.validateUserForAssetCreate(userId, (Asset)process);
        this.validateProcessParameters(userId, process.getQualifiedName(), "createProcess");
        ProcessPropertiesBuilder builder = new ProcessPropertiesBuilder(process.getQualifiedName(), process.getName(), process.getDisplayName(), process.getDescription(), process.getOwner(), process.getOwnerType(), process.getZoneMembership(), process.getLatestChange(), process.getFormula(), null, null, this.repositoryHelper, this.serverName, this.serviceName);
        String processGUID = this.dataEngineCommonHandler.createExternalEntity(userId, builder.getInstanceProperties("createProcess"), InstanceStatus.DRAFT, "Process", externalSourceName);
        this.classifyAsset(userId, process, processGUID);
        return processGUID;
    }

    public void updateProcess(String userId, EntityDetail originalProcessEntity, Process updatedProcess) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        this.initializeAssetZoneMembership(updatedProcess);
        this.validateProcessParameters(userId, updatedProcess.getQualifiedName(), "updateProcess");
        String processGUID = originalProcessEntity.getGUID();
        ProcessConverter processConverter = new ProcessConverter(originalProcessEntity, null, this.repositoryHelper, "updateProcess");
        Process originalProcess = processConverter.getProcessBean();
        this.validateZoneMembership(userId, originalProcess, updatedProcess, processConverter.getAssetAuditHeader());
        ProcessPropertiesBuilder updatedProcessBuilder = new ProcessPropertiesBuilder(updatedProcess.getQualifiedName(), updatedProcess.getName(), updatedProcess.getDisplayName(), updatedProcess.getDescription(), updatedProcess.getOwner(), updatedProcess.getOwnerType(), updatedProcess.getZoneMembership(), updatedProcess.getLatestChange(), updatedProcess.getFormula(), null, null, this.repositoryHelper, this.serverName, this.serviceName);
        this.assetHandler.reclassifyAsset(userId, (Asset)originalProcess, (Asset)updatedProcess, updatedProcessBuilder.getZoneMembershipProperties("updateProcess"), updatedProcessBuilder.getOwnerProperties("updateProcess"), "updateProcess");
        EntityDetail updatedProcessEntity = this.dataEngineCommonHandler.buildEntityDetail(processGUID, updatedProcessBuilder.getInstanceProperties("updateProcess"));
        EntityDetailDifferences entityDetailDifferences = this.repositoryHelper.getEntityDetailDifferences(originalProcessEntity, updatedProcessEntity, true);
        if (!entityDetailDifferences.hasInstancePropertiesDifferences()) {
            return;
        }
        this.dataEngineCommonHandler.updateEntity(userId, processGUID, updatedProcessBuilder.getInstanceProperties("updateProcess"), "Process");
    }

    public Optional<EntityDetail> findProcessEntity(String userId, String qualifiedName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        return this.dataEngineCommonHandler.findEntity(userId, qualifiedName, "Process");
    }

    public void addProcessPortRelationship(String userId, String processGUID, String portGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.dataEngineCommonHandler.createOrUpdateExternalRelationship(userId, processGUID, portGUID, "ProcessPort", "Process", externalSourceName, null);
    }

    public void updateProcessStatus(String userId, String guid, InstanceStatus instanceStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        this.invalidParameterHandler.validateUserId(userId, "updateProcessStatus");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateProcessStatus");
        TypeDef entityTypeDef = this.repositoryHelper.getTypeDefByName(userId, "Process");
        this.repositoryHandler.updateEntityStatus(userId, guid, entityTypeDef.getGUID(), entityTypeDef.getName(), instanceStatus, "updateProcessStatus");
    }

    public Set<String> getPortsForProcess(String userId, String processGUID, String portTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPortsForProcess";
        this.invalidParameterHandler.validateUserId(userId, "getPortsForProcess");
        this.invalidParameterHandler.validateGUID(processGUID, "guid", "getPortsForProcess");
        TypeDef relationshipTypeDef = this.repositoryHelper.getTypeDefByName(userId, "ProcessPort");
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, processGUID, "Process", relationshipTypeDef.getGUID(), relationshipTypeDef.getName(), 0, 0, "getPortsForProcess");
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashSet<String>();
        }
        return entities.parallelStream().filter(entityDetail -> entityDetail.getType().getTypeDefName().equalsIgnoreCase(portTypeName)).map(InstanceHeader::getGUID).collect(Collectors.toSet());
    }

    private void validateZoneMembership(String userId, Process originalProcess, Process updatedProcess, AssetAuditHeader assetAuditHeader) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "validateZoneMembership";
        this.invalidParameterHandler.validateAssetInSupportedZone(updatedProcess.getGUID(), "guid", originalProcess.getZoneMembership(), this.supportedZones, this.serviceName, methodName);
        updatedProcess.setZoneMembership(this.securityVerifier.verifyAssetZones(this.defaultZones, this.securityVerifier.setSupportedZonesForUser(this.supportedZones, this.serviceName, userId), (Asset)originalProcess, (Asset)updatedProcess));
        this.securityVerifier.validateUserForAssetDetailUpdate(userId, (Asset)originalProcess, assetAuditHeader, (Asset)updatedProcess);
    }

    private void validateProcessParameters(String userId, String qualifiedName, String methodName) throws InvalidParameterException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
    }

    private void classifyAsset(String userId, Process process, String processGUID) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyAsset";
        ProcessPropertiesBuilder builder = new ProcessPropertiesBuilder(process.getQualifiedName(), process.getName(), process.getDisplayName(), process.getDescription(), process.getOwner(), process.getOwnerType(), process.getZoneMembership(), process.getLatestChange(), process.getFormula(), null, null, this.repositoryHelper, this.serverName, this.serviceName);
        if (!CollectionUtils.isEmpty((Collection)process.getZoneMembership())) {
            InstanceProperties zoneMembershipProperties = builder.getZoneMembershipProperties("classifyAsset");
            this.repositoryHandler.classifyEntity(userId, processGUID, "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", zoneMembershipProperties, "classifyAsset");
        }
        if (!StringUtils.isEmpty((Object)process.getOwner())) {
            InstanceProperties ownerProperties = builder.getOwnerProperties("classifyAsset");
            this.repositoryHandler.classifyEntity(userId, processGUID, "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", ownerProperties, "classifyAsset");
        }
    }

    public void createOrUpdateProcessHierarchyRelationship(String userId, ParentProcess parentProcess, String processGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createOrUpdateProcessHierarchyRelationship";
        ProcessContainmentType processContainmentType = parentProcess.getProcessContainmentType();
        InstanceProperties relationshipProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, "containmentType", processContainmentType.getOrdinal(), processContainmentType.getName(), processContainmentType.getDescription(), "createOrUpdateProcessHierarchyRelationship");
        Optional<EntityDetail> parentProcessEntity = this.findProcessEntity(userId, parentProcess.getQualifiedName());
        if (parentProcessEntity.isPresent()) {
            this.dataEngineCommonHandler.createOrUpdateExternalRelationship(userId, parentProcessEntity.get().getGUID(), processGUID, "ProcessHierarchy", "Process", externalSourceName, relationshipProperties);
        } else {
            this.dataEngineCommonHandler.throwInvalidParameterException(DataEngineErrorCode.PROCESS_NOT_FOUND, "createOrUpdateProcessHierarchyRelationship", "qualifiedName", parentProcess.getQualifiedName());
        }
    }

    private void initializeAssetZoneMembership(Process updatedProcess) throws InvalidParameterException, PropertyServerException {
        List zoneMembership = this.securityVerifier.initializeAssetZones(this.defaultZones, (Asset)updatedProcess);
        updatedProcess.setZoneMembership(zoneMembership);
    }
}

