/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEnginePortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.DATA_ENGINE_OMAS;
    private final DataEngineProcessHandler processHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private final DataEnginePortHandler dataEnginePortHandler;
    private final AssetHandler<Process> assetHandler;
    private final SchemaTypeHandler<SchemaType> schemaTypeHandler;
    private final SchemaAttributeHandler<SchemaAttribute, SchemaType> schemaAttributeHandler;
    private final Connection inTopicConnection;

    DataEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection inTopicConnection) throws NewInstanceException {
        super(description.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, null, auditLog, localServerUserId, maxPageSize);
        this.inTopicConnection = inTopicConnection;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(DataEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.assetHandler = new AssetHandler(new ProcessConverter(this.repositoryHelper, this.serviceName, this.serverName), Process.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.schemaTypeHandler = new SchemaTypeHandler(new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaType.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.schemaAttributeHandler = new SchemaAttributeHandler(new SchemaAttributeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaAttribute.class, new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaType.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.dataEngineRegistrationHandler = new DataEngineRegistrationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
        DataEngineCommonHandler dataEngineCommonHandler = new DataEngineCommonHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataEngineRegistrationHandler);
        this.processHandler = new DataEngineProcessHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.assetHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        this.dataEngineSchemaTypeHandler = new DataEngineSchemaTypeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.schemaTypeHandler, this.schemaAttributeHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        this.dataEnginePortHandler = new DataEnginePortHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, dataEngineCommonHandler);
    }

    DataEngineProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    DataEngineRegistrationHandler getDataEngineRegistrationHandler() {
        return this.dataEngineRegistrationHandler;
    }

    DataEngineSchemaTypeHandler getDataEngineSchemaTypeHandler() {
        return this.dataEngineSchemaTypeHandler;
    }

    DataEnginePortHandler getPortHandler() {
        return this.dataEnginePortHandler;
    }

    Connection getInTopicConnection() {
        return this.inTopicConnection;
    }
}

