/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessPropertiesBuilder
extends AssetBuilder {
    private final String processDisplayName;
    private final String formula;

    public ProcessPropertiesBuilder(String qualifiedName, String processDisplayName, String technicalName, String technicalDescription, List<String> zoneMembership, String owner, int ownerType, String typeGUID, String typeName, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, InstanceStatus initialStatus, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, String userId, String methodName) throws InvalidParameterException {
        super(qualifiedName, technicalName, technicalDescription, additionalProperties, typeGUID, typeName, extendedProperties, initialStatus, repositoryHelper, serviceName, serverName);
        if (zoneMembership != null) {
            this.setAssetZones(userId, zoneMembership, methodName);
        }
        this.setAssetOwnership(userId, owner, ownerType, methodName);
        this.processDisplayName = processDisplayName;
        this.formula = formula;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.processDisplayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.processDisplayName, methodName);
        }
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        return properties;
    }
}

