/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.dataengine.event.DataEngineEventHeader;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineAuditCode;
import org.odpi.openmetadata.accessservices.dataengine.server.processors.DataEngineEventProcessor;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEngineInTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(DataEngineInTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AuditLog auditLog;
    private DataEngineEventProcessor dataEngineEventProcessor;

    public DataEngineInTopicListener(AuditLog auditLog, DataEngineEventProcessor dataEngineEventProcessor) {
        this.auditLog = auditLog;
        this.dataEngineEventProcessor = dataEngineEventProcessor;
    }

    public void processEvent(String dataEngineEvent) {
        log.debug("Processing instance event {}", (Object)dataEngineEvent);
        if (dataEngineEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            try {
                DataEngineEventHeader dataEngineEventHeader = (DataEngineEventHeader)OBJECT_MAPPER.readValue(dataEngineEvent, DataEngineEventHeader.class);
                if (dataEngineEventHeader != null) {
                    switch (dataEngineEventHeader.getEventType()) {
                        case DATA_ENGINE_REGISTRATION_EVENT: {
                            this.dataEngineEventProcessor.processDataEngineRegistrationEvent(dataEngineEvent);
                            break;
                        }
                        case LINEAGE_MAPPINGS_EVENT: {
                            this.dataEngineEventProcessor.processLineageMappingsEvent(dataEngineEvent);
                            break;
                        }
                        case PORT_ALIAS_EVENT: {
                            this.dataEngineEventProcessor.processPortAliasEvent(dataEngineEvent);
                            break;
                        }
                        case PORT_IMPLEMENTATION_EVENT: {
                            this.dataEngineEventProcessor.processPortImplementationEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESS_TO_PORT_LIST_EVENT: {
                            this.dataEngineEventProcessor.processProcessToPortListEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESSES_EVENT: {
                            this.dataEngineEventProcessor.processProcessesEvent(dataEngineEvent);
                            break;
                        }
                        case SCHEMA_TYPE_EVENT: {
                            this.dataEngineEventProcessor.processSchemaTypeEvent(dataEngineEvent);
                            break;
                        }
                        case PROCESS_HIERARCHY_EVENT: {
                            this.dataEngineEventProcessor.processProcessHierarchyEvent(dataEngineEvent);
                            break;
                        }
                        default: {
                            log.debug("Ignored instance event - unknown event type");
                            break;
                        }
                    }
                } else {
                    log.debug("Ignored instance event - null Data Engine event type");
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Exception processing event from in Data Engine In Topic", (Throwable)e);
                this.auditLog.logException("process Data Engine inTopic Event", DataEngineAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{e.getMessage()}), (Throwable)e);
            }
        }
    }
}

