/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.converters;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProcessConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    private static final int OWNER_TYPE_OTHER = 99;

    public ProcessConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> processClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = processClass.newInstance();
            if (returnBean instanceof Process) {
                Process process = (Process)returnBean;
                if (entity != null) {
                    InstanceType type = entity.getType();
                    process.setTypeGUID(type.getTypeDefGUID());
                    process.setTypeName(type.getTypeDefName());
                    process.setGUID(entity.getGUID());
                    InstanceProperties entityProperties = entity.getProperties();
                    if (entityProperties != null) {
                        InstanceProperties instanceProperties = new InstanceProperties(entityProperties);
                        process.setName(this.removeName(instanceProperties));
                        process.setQualifiedName(this.removeQualifiedName(instanceProperties));
                        process.setDisplayName(this.removeDisplayName(instanceProperties));
                        process.setDescription(this.removeDescription(instanceProperties));
                        process.setOwner(this.removeOwner(instanceProperties));
                        process.setOwnerType(this.removeOwnerTypeFromProperties(instanceProperties));
                        process.setZoneMembership(this.removeZoneMembership(instanceProperties));
                        process.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                        process.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                        process.setFormula(this.repositoryHelper.removeStringProperty(this.serviceName, "formula", instanceProperties, methodName));
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(processClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        return (B)super.getNewComplexBean(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
    }

    int removeOwnerTypeFromProperties(InstanceProperties properties) {
        int ownerType = this.getOwnerTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerType;
    }

    int getOwnerTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        int ownerType = 99;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            ownerType = enumPropertyValue.getOrdinal();
        }
        return ownerType;
    }
}

