/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.LineageMapping;
import org.odpi.openmetadata.accessservices.dataengine.model.ParentProcess;
import org.odpi.openmetadata.accessservices.dataengine.model.PortAlias;
import org.odpi.openmetadata.accessservices.dataengine.model.PortImplementation;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.ProcessHierarchy;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.model.SoftwareServerCapability;
import org.odpi.openmetadata.accessservices.dataengine.model.UpdateSemantic;
import org.odpi.openmetadata.accessservices.dataengine.rest.DataEngineRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.LineageMappingsRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortAliasRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortImplementationRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.PortListRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessHierarchyRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessListResponse;
import org.odpi.openmetadata.accessservices.dataengine.rest.ProcessesRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.rest.SchemaTypeRequestBody;
import org.odpi.openmetadata.accessservices.dataengine.server.admin.DataEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEnginePortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DataEngineRESTServices {
    private static final Logger log = LoggerFactory.getLogger(DataEngineRESTServices.class);
    private static final String DEBUG_MESSAGE_METHOD_DETAILS = "Calling method {} for entity: {}";
    private static final String DEBUG_MESSAGE_METHOD_RETURN = "Returning from method: {} with response: {}";
    public static final String EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING = "Exception while adding lineage mapping {} : {}";
    public static final String EXCEPTION_WHILE_CREATING_PROCESS = "Exception while creating process {} : {}";
    public static final String EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY = "Exception while creating process relationships for process {} : {}";
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final DataEngineInstanceHandler instanceHandler = new DataEngineInstanceHandler();

    public GUIDResponse createExternalDataEngine(String serverName, String userId, DataEngineRegistrationRequestBody requestBody) {
        String methodName = "createExternalDataEngine";
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createExternalDataEngine", serverName);
                return response;
            }
            response.setGUID(this.createExternalDataEngine(userId, serverName, requestBody.getSoftwareServerCapability()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"createExternalDataEngine", (Object)response);
        return response;
    }

    public GUIDResponse getExternalDataEngineByQualifiedName(String serverName, String userId, String qualifiedName) {
        String methodName = "getExternalDataEngineByQualifiedName";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"getExternalDataEngineByQualifiedName", (Object)qualifiedName);
        GUIDResponse response = new GUIDResponse();
        try {
            DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "getExternalDataEngineByQualifiedName");
            response.setGUID(handler.getExternalDataEngineByQualifiedName(userId, qualifiedName));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"getExternalDataEngineByQualifiedName", (Object)response);
        return response;
    }

    public GUIDResponse upsertSchemaType(String userId, String serverName, SchemaTypeRequestBody schemaTypeRequestBody) {
        String methodName = "upsertSchemaType";
        GUIDResponse response = new GUIDResponse();
        try {
            if (schemaTypeRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "upsertSchemaType", serverName);
                return response;
            }
            String newSchemaTypeGUID = this.upsertSchemaType(userId, serverName, schemaTypeRequestBody.getSchemaType(), schemaTypeRequestBody.getExternalSourceName());
            response.setGUID(newSchemaTypeGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        return response;
    }

    public GUIDResponse upsertPortImplementation(String userId, String serverName, PortImplementationRequestBody portImplementationRequestBody) {
        String methodName = "upsertPortImplementation";
        GUIDResponse response = new GUIDResponse();
        try {
            if (portImplementationRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "upsertPortImplementation", serverName);
                return response;
            }
            String portImplementationGUID = this.upsertPortImplementationWithSchemaType(userId, serverName, portImplementationRequestBody.getPortImplementation(), portImplementationRequestBody.getExternalSourceName());
            response.setGUID(portImplementationGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        return response;
    }

    public GUIDResponse upsertPortAlias(String userId, String serverName, PortAliasRequestBody portAliasRequestBody) {
        String methodName = "upsertPortAliasWithDelegation";
        GUIDResponse response = new GUIDResponse();
        try {
            if (portAliasRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "upsertPortAliasWithDelegation", serverName);
                return response;
            }
            response.setGUID(this.upsertPortAliasWithDelegation(userId, serverName, portAliasRequestBody.getPortAlias(), portAliasRequestBody.getExternalSourceName()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        return response;
    }

    public GUIDResponse addProcessHierarchy(String userId, String serverName, ProcessHierarchyRequestBody processHierarchyRequestBody) {
        String methodName = "addProcessHierarchy";
        GUIDResponse response = new GUIDResponse();
        try {
            if (processHierarchyRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addProcessHierarchy", serverName);
                return response;
            }
            response.setGUID(this.addProcessHierarchyToProcess(userId, serverName, processHierarchyRequestBody.getProcessHierarchy(), processHierarchyRequestBody.getExternalSourceName()));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        return response;
    }

    public ProcessListResponse upsertProcesses(String userId, String serverName, ProcessesRequestBody processesRequestBody) {
        String methodName = "upsertProcesses";
        ProcessListResponse response = new ProcessListResponse();
        try {
            if (processesRequestBody == null || CollectionUtils.isEmpty((Collection)processesRequestBody.getProcesses())) {
                this.restExceptionHandler.handleNoRequestBody(userId, "upsertProcesses", serverName);
                return response;
            }
            return this.upsertProcesses(userId, serverName, processesRequestBody.getProcesses(), processesRequestBody.getExternalSourceName());
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            return response;
        }
    }

    public String upsertPortAliasWithDelegation(String userId, String serverName, PortAlias portAlias, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portAliasGUID;
        String methodName = "upsertPortAliasWithDelegation";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortAliasWithDelegation", (Object)portAlias);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortAliasWithDelegation");
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortAliasEntity(userId, portAlias.getQualifiedName());
        if (!portEntity.isPresent()) {
            portAliasGUID = dataEnginePortHandler.createPortAlias(userId, portAlias, externalSourceName);
        } else {
            portAliasGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortAlias(userId, portEntity.get(), portAlias, externalSourceName);
        }
        if (!StringUtils.isEmpty((CharSequence)portAlias.getDelegatesTo())) {
            dataEnginePortHandler.addPortDelegationRelationship(userId, portAliasGUID, portAlias.getPortType(), portAlias.getDelegatesTo(), externalSourceName);
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortAliasWithDelegation", (Object)portAliasGUID);
        return portAliasGUID;
    }

    public String addProcessHierarchyToProcess(String userId, String serverName, ProcessHierarchy processHierarchy, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessHierarchyToProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addProcessHierarchyToProcess", (Object)processHierarchy);
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyToProcess");
        Optional<EntityDetail> childProcessEntity = processHandler.findProcessEntity(userId, processHierarchy.getChildProcess());
        if (!childProcessEntity.isPresent()) {
            throw new InvalidParameterException(DataEngineErrorCode.PROCESS_NOT_FOUND.getMessageDefinition(new String[]{processHierarchy.getChildProcess()}), this.getClass().getName(), "addProcessHierarchyToProcess", "childProcess");
        }
        String childProcessGUID = childProcessEntity.get().getGUID();
        ParentProcess parentProcess = new ParentProcess();
        parentProcess.setQualifiedName(processHierarchy.getParentProcess());
        parentProcess.setProcessContainmentType(processHierarchy.getProcessContainmentType());
        processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, childProcessGUID, externalSourceName);
        log.info("Data Engine OMAS has added a relationship of type ProcessHierarchy between child process {} and parent process {}", (Object)processHierarchy.getChildProcess(), (Object)processHierarchy.getParentProcess());
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addProcessHierarchyToProcess", (Object)childProcessGUID);
        return childProcessGUID;
    }

    public String upsertPortImplementationWithSchemaType(String userId, String serverName, PortImplementation portImplementation, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String portImplementationGUID;
        String methodName = "upsertPortImplementationWithSchemaType";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertPortImplementationWithSchemaType", (Object)portImplementation);
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "upsertPortImplementationWithSchemaType");
        String schemaTypeGUID = this.upsertSchemaType(userId, serverName, portImplementation.getSchemaType(), externalSourceName);
        Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortImplementationEntity(userId, portImplementation.getQualifiedName());
        if (!portEntity.isPresent()) {
            portImplementationGUID = dataEnginePortHandler.createPortImplementation(userId, portImplementation, externalSourceName);
        } else {
            portImplementationGUID = portEntity.get().getGUID();
            dataEnginePortHandler.updatePortImplementation(userId, portEntity.get(), portImplementation, externalSourceName);
            if (portImplementation.getUpdateSemantic() == UpdateSemantic.REPLACE) {
                this.deleteObsoleteSchemaType(userId, serverName, schemaTypeGUID, dataEnginePortHandler.findSchemaTypeForPort(userId, portImplementationGUID), externalSourceName);
            }
        }
        dataEnginePortHandler.addPortSchemaRelationship(userId, portImplementationGUID, schemaTypeGUID, externalSourceName);
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertPortImplementationWithSchemaType", (Object)portImplementationGUID);
        return portImplementationGUID;
    }

    public String createExternalDataEngine(String userId, String serverName, SoftwareServerCapability softwareServerCapability) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createExternalDataEngine";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"createExternalDataEngine", (Object)softwareServerCapability);
        if (softwareServerCapability == null) {
            return null;
        }
        DataEngineRegistrationHandler handler = this.instanceHandler.getRegistrationHandler(userId, serverName, "createExternalDataEngine");
        String softwareServerCapabilityGUID = handler.upsertExternalDataEngine(userId, softwareServerCapability);
        log.info("Data Engine OMAS has registered an external engine with qualified name {} and GUID {}", (Object)softwareServerCapability.getQualifiedName(), (Object)softwareServerCapabilityGUID);
        return softwareServerCapabilityGUID;
    }

    public void addPortsToProcess(String userId, String serverName, String processGUID, List<String> portQualifiedNames, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addPortsToProcess";
        if (CollectionUtils.isEmpty(portQualifiedNames)) {
            return;
        }
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addPortsToProcess");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "addPortsToProcess");
        for (String portQualifiedName : portQualifiedNames) {
            Optional<EntityDetail> portEntity = dataEnginePortHandler.findPortEntity(userId, portQualifiedName);
            if (!portEntity.isPresent()) continue;
            processHandler.addProcessPortRelationship(userId, processGUID, portEntity.get().getGUID(), externalSourceName);
        }
    }

    public void addLineageMappings(String userId, String serverName, List<LineageMapping> lineageMappings, FFDCResponseBase response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLineageMappings";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"addLineageMappings", lineageMappings);
        if (CollectionUtils.isEmpty(lineageMappings)) {
            return;
        }
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addLineageMappings");
        lineageMappings.parallelStream().forEach(lineageMapping -> {
            try {
                dataEngineSchemaTypeHandler.addLineageMappingRelationship(userId, lineageMapping.getSourceAttribute(), lineageMapping.getTargetAttribute(), externalSourceName);
            }
            catch (InvalidParameterException error) {
                log.error(EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING, (Object)lineageMapping.toString(), (Object)error.toString());
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                log.error(EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING, (Object)lineageMapping.toString(), (Object)error.toString());
                this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                log.error(EXCEPTION_WHILE_ADDING_LINEAGE_MAPPING, (Object)lineageMapping.toString(), (Object)error.toString());
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
        });
    }

    public ProcessListResponse upsertProcesses(String userId, String serverName, List<Process> processes, String externalSourceName) {
        String methodName = "upsertProcesses";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertProcesses", processes);
        Predicate<Process> hasPortImplementationsPredicate = process -> CollectionUtils.isNotEmpty((Collection)process.getPortImplementations());
        Map<Boolean, List<Process>> partitionedProcesses = processes.parallelStream().collect(Collectors.partitioningBy(hasPortImplementationsPredicate));
        ArrayList createdProcesses = new ArrayList();
        ArrayList<GUIDResponse> failedProcesses = new ArrayList<GUIDResponse>();
        Consumer<Process> processConsumer = process -> {
            GUIDResponse guidResponse = this.upsertProcess(userId, serverName, (Process)process, externalSourceName);
            if (guidResponse.getRelatedHTTPCode() == HttpStatus.OK.value()) {
                String processGUID = guidResponse.getGUID();
                process.setGUID(processGUID);
                VoidResponse updateStatusResponse = this.updateProcessStatus(userId, serverName, (Process)process, InstanceStatus.ACTIVE, externalSourceName);
                if (updateStatusResponse.getRelatedHTTPCode() != 200) {
                    this.captureException((FFDCResponseBase)updateStatusResponse, (FFDCResponseBase)guidResponse);
                }
                createdProcesses.add(guidResponse);
            } else {
                failedProcesses.add(guidResponse);
            }
        };
        partitionedProcesses.get(Boolean.TRUE).parallelStream().forEach(processConsumer);
        partitionedProcesses.get(Boolean.FALSE).forEach(processConsumer);
        ProcessListResponse response = new ProcessListResponse();
        response.setGUIDs(createdProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        this.handleFailedProcesses(response, failedProcesses);
        this.addProcessHierarchyRelationships(userId, serverName, processes, response, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertProcesses", (Object)response);
        return response;
    }

    public GUIDResponse addPortsToProcess(String userId, String serverName, String processGuid, PortListRequestBody portListRequestBody) {
        String methodName = "addPortsToProcess";
        GUIDResponse response = new GUIDResponse();
        try {
            if (portListRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addPortsToProcess", serverName);
                return response;
            }
            this.addPortsToProcess(userId, serverName, processGuid, portListRequestBody.getPorts(), portListRequestBody.getExternalSourceName());
            response.setGUID(processGuid);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addPortsToProcess", (Object)response);
        return response;
    }

    public VoidResponse addLineageMappings(String userId, String serverName, LineageMappingsRequestBody lineageMappingsRequestBody) {
        String methodName = "addLineageMappings";
        VoidResponse response = new VoidResponse();
        try {
            if (lineageMappingsRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addLineageMappings", serverName);
                return response;
            }
            this.addLineageMappings(userId, serverName, lineageMappingsRequestBody.getLineageMappings(), (FFDCResponseBase)response, lineageMappingsRequestBody.getExternalSourceName());
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"addLineageMappings", (Object)response);
        return response;
    }

    public ConnectionResponse getInTopicConnection(String serverName, String userId) {
        String methodName = "getInTopicConnection";
        ConnectionResponse response = new ConnectionResponse();
        try {
            response.setConnection(this.instanceHandler.getInTopicConnection(userId, serverName, "getInTopicConnection"));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        return response;
    }

    public String upsertSchemaType(String userId, String serverName, SchemaType schemaType, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "upsertSchemaType";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertSchemaType", (Object)schemaType);
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "upsertSchemaType");
        String schemaTypeGUID = dataEngineSchemaTypeHandler.upsertSchemaType(userId, schemaType, externalSourceName);
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertSchemaType", (Object)schemaTypeGUID);
        return schemaTypeGUID;
    }

    private void deleteObsoleteSchemaType(String userId, String serverName, String schemaTypeGUID, String oldSchemaTypeGUID, String externalSourceName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteObsoleteSchemaType";
        if (!oldSchemaTypeGUID.equalsIgnoreCase(schemaTypeGUID)) {
            DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "deleteObsoleteSchemaType");
            dataEngineSchemaTypeHandler.removeSchemaType(userId, oldSchemaTypeGUID, externalSourceName);
        }
    }

    private void handleFailedProcesses(ProcessListResponse response, List<GUIDResponse> failedProcesses) {
        response.setFailedGUIDs(failedProcesses.parallelStream().map(GUIDResponse::getGUID).collect(Collectors.toList()));
        failedProcesses.parallelStream().forEach(guidResponse -> this.captureException((FFDCResponseBase)guidResponse, (FFDCResponseBase)response));
    }

    private void captureException(FFDCResponseBase initialResponse, FFDCResponseBase response) {
        response.setExceptionErrorMessage(initialResponse.getExceptionErrorMessage());
        response.setExceptionClassName(initialResponse.getExceptionClassName());
        response.setExceptionSystemAction(initialResponse.getExceptionSystemAction());
        response.setExceptionUserAction(initialResponse.getExceptionUserAction());
        response.setRelatedHTTPCode(initialResponse.getRelatedHTTPCode());
        response.setExceptionProperties(initialResponse.getExceptionProperties());
    }

    private VoidResponse updateProcessStatus(String userId, String serverName, Process process, InstanceStatus instanceStatus, String externalSourceName) {
        String methodName = "updateProcessStatus";
        log.trace(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"updateProcessStatus", (Object)process.getGUID());
        VoidResponse response = new VoidResponse();
        try {
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "updateProcessStatus");
            processHandler.updateProcessStatus(userId, process.getGUID(), instanceStatus, externalSourceName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.trace(DEBUG_MESSAGE_METHOD_RETURN, (Object)"updateProcessStatus", (Object)response);
        return response;
    }

    private GUIDResponse upsertProcess(String userId, String serverName, Process process, String externalSourceName) {
        String methodName = "upsertProcess";
        log.debug(DEBUG_MESSAGE_METHOD_DETAILS, (Object)"upsertProcess", (Object)process);
        String qualifiedName = process.getQualifiedName();
        List portImplementations = process.getPortImplementations();
        List portAliases = process.getPortAliases();
        List lineageMappings = process.getLineageMappings();
        UpdateSemantic updateSemantic = process.getUpdateSemantic();
        GUIDResponse response = new GUIDResponse();
        try {
            String processGUID;
            Set<String> portImplementationGUIDs = this.upsertPortImplementations(userId, serverName, portImplementations, response, externalSourceName);
            Set<String> portAliasGUIDs = this.upsertPortAliases(userId, serverName, portAliases, response, externalSourceName);
            if (response.getRelatedHTTPCode() != HttpStatus.OK.value()) {
                return response;
            }
            DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "upsertProcess");
            Optional<EntityDetail> processEntity = processHandler.findProcessEntity(userId, qualifiedName);
            if (!processEntity.isPresent()) {
                processGUID = processHandler.createProcess(userId, process, externalSourceName);
                List<Attribute> schemaAttributes = this.getAttributes(portImplementations);
                this.addAnchorGUID(userId, serverName, processGUID, schemaAttributes, externalSourceName);
            } else {
                processGUID = processEntity.get().getGUID();
                processHandler.updateProcess(userId, processEntity.get(), process, externalSourceName);
                processHandler.updateProcessStatus(userId, processGUID, InstanceStatus.DRAFT, externalSourceName);
                if (updateSemantic == UpdateSemantic.REPLACE) {
                    this.deleteObsoletePorts(userId, serverName, portImplementationGUIDs, processGUID, "PortImplementation", response, externalSourceName);
                    this.deleteObsoletePorts(userId, serverName, portAliasGUIDs, processGUID, "PortAlias", response, externalSourceName);
                }
            }
            this.addProcessPortRelationships(userId, serverName, processGUID, Stream.concat(portImplementationGUIDs.stream(), portAliasGUIDs.stream()).collect(Collectors.toSet()), response, externalSourceName);
            this.addLineageMappings(userId, serverName, lineageMappings, (FFDCResponseBase)response, externalSourceName);
            log.info("Data Engine OMAS has created or updated a Process with qualified name {} and guid {}", (Object)qualifiedName, (Object)processGUID);
            response.setGUID(processGUID);
        }
        catch (InvalidParameterException error) {
            log.error(EXCEPTION_WHILE_CREATING_PROCESS, (Object)qualifiedName, (Object)error.toString());
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            log.error(EXCEPTION_WHILE_CREATING_PROCESS, (Object)qualifiedName, (Object)error.toString());
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            log.error(EXCEPTION_WHILE_CREATING_PROCESS, (Object)qualifiedName, (Object)error.toString());
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        log.debug(DEBUG_MESSAGE_METHOD_RETURN, (Object)"upsertProcess", (Object)response);
        return response;
    }

    private List<Attribute> getAttributes(List<PortImplementation> portImplementations) {
        if (CollectionUtils.isEmpty(portImplementations)) {
            return new ArrayList<Attribute>();
        }
        return portImplementations.stream().map(portImplementation -> portImplementation.getSchemaType().getAttributeList()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void addAnchorGUID(String userId, String serverName, String processGUID, List<Attribute> schemaAttributes, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addAnchorGUID";
        DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler = this.instanceHandler.getDataEngineSchemaTypeHandler(userId, serverName, "addAnchorGUID");
        for (Attribute attribute : schemaAttributes) {
            dataEngineSchemaTypeHandler.addAnchorGUID(userId, attribute, processGUID, externalSourceName);
        }
    }

    private void addProcessHierarchyRelationships(String userId, String serverName, List<Process> processes, ProcessListResponse response, String externalSourceName) {
        String methodName = "addProcessHierarchyRelationships";
        processes.parallelStream().filter(process -> response.getGUIDs().contains(process.getGUID())).forEach(process -> {
            List parentProcesses = process.getParentProcesses();
            String processGUID = process.getGUID();
            if (CollectionUtils.isNotEmpty((Collection)parentProcesses)) {
                try {
                    DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessHierarchyRelationships");
                    for (ParentProcess parentProcess : parentProcesses) {
                        processHandler.upsertProcessHierarchyRelationship(userId, parentProcess, processGUID, externalSourceName);
                    }
                }
                catch (InvalidParameterException error) {
                    log.error(EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY, (Object)process.getQualifiedName(), (Object)error.toString());
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
                }
                catch (PropertyServerException error) {
                    log.error(EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY, (Object)process.getQualifiedName(), (Object)error.toString());
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    log.error(EXCEPTION_WHILE_CREATING_PROCESS_HIERARCHY, (Object)process.getQualifiedName(), (Object)error.toString());
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
                }
            }
        });
    }

    private void addProcessPortRelationships(String userId, String serverName, String processGUID, Set<String> portGUIDs, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addProcessPortRelationships";
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "addProcessPortRelationships");
        portGUIDs.parallelStream().forEach(portGUID -> {
            try {
                processHandler.addProcessPortRelationship(userId, processGUID, (String)portGUID, externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
        });
    }

    private void deleteObsoletePorts(String userId, String serverName, Set<String> newPortGUIDs, String processGUID, String portTypeName, GUIDResponse response, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteObsoletePorts";
        if (CollectionUtils.isEmpty(newPortGUIDs)) {
            return;
        }
        DataEngineProcessHandler processHandler = this.instanceHandler.getProcessHandler(userId, serverName, "deleteObsoletePorts");
        DataEnginePortHandler dataEnginePortHandler = this.instanceHandler.getPortHandler(userId, serverName, "deleteObsoletePorts");
        Set<String> oldPortGUIDs = processHandler.getPortsForProcess(userId, processGUID, portTypeName);
        List<String> obsoletePorts = oldPortGUIDs.parallelStream().collect(Collectors.partitioningBy(newPortGUIDs::contains)).get(Boolean.FALSE);
        obsoletePorts.parallelStream().forEach(portGUID -> {
            try {
                dataEnginePortHandler.removePort(userId, (String)portGUID, portTypeName, externalSourceName);
            }
            catch (InvalidParameterException error) {
                this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
        });
    }

    private Set<String> upsertPortImplementations(String userId, String serverName, List<PortImplementation> portImplementations, GUIDResponse response, String externalSourceName) {
        HashSet<String> portImplementationGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portImplementations)) {
            portImplementations.parallelStream().forEach(portImplementation -> {
                try {
                    portImplementationGUIDs.add(this.upsertPortImplementationWithSchemaType(userId, serverName, (PortImplementation)portImplementation, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
                }
            });
        }
        return portImplementationGUIDs;
    }

    private Set<String> upsertPortAliases(String userId, String serverName, List<PortAlias> portAliases, GUIDResponse response, String externalSourceName) {
        HashSet<String> portAliasGUIDs = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(portAliases)) {
            portAliases.parallelStream().forEach(portAlias -> {
                try {
                    portAliasGUIDs.add(this.upsertPortAliasWithDelegation(userId, serverName, (PortAlias)portAlias, externalSourceName));
                }
                catch (InvalidParameterException error) {
                    this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
                }
                catch (PropertyServerException error) {
                    this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
                }
                catch (UserNotAuthorizedException error) {
                    this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
                }
            });
        }
        return portAliasGUIDs;
    }
}

