/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.server.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.dataengine.ffdc.DataEngineErrorCode;
import org.odpi.openmetadata.accessservices.dataengine.model.Attribute;
import org.odpi.openmetadata.accessservices.dataengine.model.Collection;
import org.odpi.openmetadata.accessservices.dataengine.model.DataFile;
import org.odpi.openmetadata.accessservices.dataengine.model.Database;
import org.odpi.openmetadata.accessservices.dataengine.model.DatabaseSchema;
import org.odpi.openmetadata.accessservices.dataengine.model.FileFolder;
import org.odpi.openmetadata.accessservices.dataengine.model.Process;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalColumn;
import org.odpi.openmetadata.accessservices.dataengine.model.RelationalTable;
import org.odpi.openmetadata.accessservices.dataengine.model.SchemaType;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.CollectionCoverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.DataFileConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.DatabaseColumnConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.DatabaseConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.DatabaseSchemaConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.DatabaseTableConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.FileFolderConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.ProcessConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.converters.SchemaTypeConverter;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCollectionHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineCommonHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineDataFileHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineFolderHierarchyHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEnginePortHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineProcessHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRegistrationHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineRelationalDataHandler;
import org.odpi.openmetadata.accessservices.dataengine.server.handlers.DataEngineSchemaTypeHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelationalDataHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DataEngineServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.DATA_ENGINE_OMAS;
    private final DataEngineProcessHandler processHandler;
    private final DataEngineRegistrationHandler dataEngineRegistrationHandler;
    private final DataEngineSchemaTypeHandler dataEngineSchemaTypeHandler;
    private final DataEngineCollectionHandler dataEngineCollectionHandler;
    private final DataEnginePortHandler dataEnginePortHandler;
    private final DataEngineRelationalDataHandler dataEngineRelationalDataHandler;
    private final Connection inTopicConnection;
    private final DataEngineDataFileHandler dataEngineDataFileHandler;
    private final DataEngineFolderHierarchyHandler dataEngineFolderHierarchyHandler;

    DataEngineServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection inTopicConnection) throws NewInstanceException {
        super(description.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, null, auditLog, localServerUserId, maxPageSize);
        this.inTopicConnection = inTopicConnection;
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(DataEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        AssetHandler assetHandler = new AssetHandler(new ProcessConverter(this.repositoryHelper, this.serviceName, this.serverName), Process.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        OpenMetadataAPIGenericHandler collectionOpenMetadataAPIGenericHandler = new OpenMetadataAPIGenericHandler(new CollectionCoverter(this.repositoryHelper, this.serviceName, this.serverName), Collection.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        SchemaTypeHandler schemaTypeHandler = new SchemaTypeHandler(new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaType.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        SchemaAttributeHandler schemaAttributeHandler = new SchemaAttributeHandler(new SchemaAttributeConverter(this.repositoryHelper, this.serviceName, this.serverName), Attribute.class, new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaType.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        RelationalDataHandler relationalDataHandler = new RelationalDataHandler(new DatabaseConverter(this.repositoryHelper, this.serviceName, this.serverName), Database.class, new DatabaseSchemaConverter(this.repositoryHelper, this.serviceName, this.serverName), DatabaseSchema.class, new DatabaseTableConverter(this.repositoryHelper, this.serviceName, this.serverName), RelationalTable.class, new DatabaseTableConverter(this.repositoryHelper, this.serviceName, this.serverName), RelationalTable.class, new DatabaseColumnConverter(this.repositoryHelper, this.serviceName, this.serverName), RelationalColumn.class, new SchemaTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), SchemaType.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.dataEngineRegistrationHandler = new DataEngineRegistrationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper);
        DataEngineCommonHandler dataEngineCommonHandler = new DataEngineCommonHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, this.dataEngineRegistrationHandler);
        this.processHandler = new DataEngineProcessHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, (AssetHandler<Process>)assetHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        this.dataEngineSchemaTypeHandler = new DataEngineSchemaTypeHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, (SchemaTypeHandler<SchemaType>)schemaTypeHandler, (SchemaAttributeHandler<Attribute, SchemaType>)schemaAttributeHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        this.dataEngineCollectionHandler = new DataEngineCollectionHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHelper, (OpenMetadataAPIGenericHandler<Collection>)collectionOpenMetadataAPIGenericHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        this.dataEnginePortHandler = new DataEnginePortHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, dataEngineCommonHandler);
        this.dataEngineRelationalDataHandler = new DataEngineRelationalDataHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, (RelationalDataHandler<Database, DatabaseSchema, RelationalTable, RelationalTable, RelationalColumn, SchemaType>)relationalDataHandler, this.dataEngineRegistrationHandler, dataEngineCommonHandler);
        AssetHandler folderHandler = new AssetHandler(new FileFolderConverter(this.repositoryHelper, this.serviceName, this.serverName), FileFolder.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.dataEngineFolderHierarchyHandler = new DataEngineFolderHierarchyHandler(this.invalidParameterHandler, this.repositoryHandler, dataEngineCommonHandler, (AssetHandler<FileFolder>)folderHandler);
        AssetHandler fileHandler = new AssetHandler(new DataFileConverter(this.repositoryHelper, this.serviceName, this.serverName), DataFile.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.dataEngineDataFileHandler = new DataEngineDataFileHandler(this.invalidParameterHandler, this.repositoryHelper, dataEngineCommonHandler, (AssetHandler<DataFile>)fileHandler, this.dataEngineSchemaTypeHandler, this.dataEngineFolderHierarchyHandler);
    }

    DataEngineProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    DataEngineRegistrationHandler getDataEngineRegistrationHandler() {
        return this.dataEngineRegistrationHandler;
    }

    DataEngineSchemaTypeHandler getDataEngineSchemaTypeHandler() {
        return this.dataEngineSchemaTypeHandler;
    }

    DataEnginePortHandler getPortHandler() {
        return this.dataEnginePortHandler;
    }

    public DataEngineCollectionHandler getDataEngineCollecttionHandler() {
        return this.dataEngineCollectionHandler;
    }

    DataEngineRelationalDataHandler getDataEngineRelationalDataHandler() {
        return this.dataEngineRelationalDataHandler;
    }

    Connection getInTopicConnection() {
        return this.inTopicConnection;
    }

    public DataEngineDataFileHandler getDataEngineDataFileHandler() {
        return this.dataEngineDataFileHandler;
    }
}

